/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.decoration;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.world.gen.feature.RCWorldgenMonitor;
import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenFossils;

public class VanillaDecorationAdapter
implements RCBiomeDecorator.Adapter {
    @Override
    public int amount(WorldServer worldIn, Random random, Biome biomeIn, BiomeDecorator decorator, BlockPos chunkPos, RCBiomeDecorator.DecorationType type) {
        switch (type) {
            case TREE: {
                int vanillaAmount = decorator.field_76832_z;
                if (random.nextFloat() < decorator.field_189870_A) {
                    ++vanillaAmount;
                }
                return vanillaAmount;
            }
            case BIG_SHROOM: {
                return decorator.field_76807_J;
            }
            case CACTUS: {
                return decorator.field_76800_F;
            }
            case DESERT_WELL: {
                return random.nextInt(100) == 0 ? 1 : 0;
            }
            case FOSSIL: {
                return random.nextInt(64) == 0 ? 1 : 0;
            }
        }
        throw new IllegalArgumentException("Unrecognized type: " + type.toString());
    }

    @Override
    public boolean mayGiveUp(WorldServer worldIn, Random random, Biome biome, BiomeDecorator decorator, BlockPos chunkPos, RCBiomeDecorator.DecorationType type) {
        return type != RCBiomeDecorator.DecorationType.DESERT_WELL && type != RCBiomeDecorator.DecorationType.FOSSIL && (type != RCBiomeDecorator.DecorationType.TREE || decorator.field_76832_z != 0);
    }

    @Override
    public boolean matches(WorldServer worldIn, Biome biome, BiomeDecorator decorator, BlockPos chunkPos, RCBiomeDecorator.DecorationType type) {
        return true;
    }

    @Override
    public void generate(WorldServer worldIn, Random random, Biome biomeIn, BiomeDecorator decorator, BlockPos chunkPos, RCBiomeDecorator.DecorationType type) {
        RCWorldgenMonitor.start("simulating vanilla decoration");
        try {
            switch (type) {
                case TREE: {
                    int k6 = random.nextInt(16) + 8;
                    int l = random.nextInt(16) + 8;
                    WorldGenAbstractTree worldgenabstracttree = biomeIn.func_150567_a(random);
                    worldgenabstracttree.func_175904_e();
                    BlockPos blockpos = worldIn.func_175645_m(chunkPos.func_177982_a(k6, 0, l));
                    if (worldgenabstracttree.func_180709_b((World)worldIn, random, blockpos)) {
                        worldgenabstracttree.func_180711_a((World)worldIn, random, blockpos);
                    }
                    break;
                }
                case BIG_SHROOM: {
                    int l6 = random.nextInt(16) + 8;
                    int k10 = random.nextInt(16) + 8;
                    decorator.field_76826_u.func_180709_b((World)worldIn, random, worldIn.func_175645_m(chunkPos.func_177982_a(l6, 0, k10)));
                    break;
                }
                case CACTUS: {
                    int l9 = random.nextInt(16) + 8;
                    int k13 = random.nextInt(16) + 8;
                    int l16 = worldIn.func_175645_m(chunkPos.func_177982_a(l9, 0, k13)).func_177956_o() * 2;
                    if (l16 > 0) {
                        int j19 = random.nextInt(l16);
                        decorator.field_76824_w.func_180709_b((World)worldIn, random, chunkPos.func_177982_a(l9, j19, k13));
                    }
                    break;
                }
                case DESERT_WELL: {
                    int i = random.nextInt(16) + 8;
                    int j = random.nextInt(16) + 8;
                    BlockPos blockpos = worldIn.func_175645_m(chunkPos.func_177982_a(i, 0, j)).func_177984_a();
                    new WorldGenDesertWells().func_180709_b((World)worldIn, random, blockpos);
                    break;
                }
                case FOSSIL: {
                    new WorldGenFossils().func_180709_b((World)worldIn, random, chunkPos);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized type: " + type.toString());
                }
            }
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error trying to emulate vanilla decoration", (Throwable)e);
        }
        RCWorldgenMonitor.stop();
    }
}

