/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.Main;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum HookType implements IForgeEnum
{
    PROTOTYPE(0.0f, 0.0f, 0, 0.0f, 0, 0.0f, 0.0f, 0),
    PUDGE(10.0f, 0.0f, 300, 0.7f, 32, 3.0f, 0.0f, -4259840),
    SPEAR(5.0f, 2.0f, 180, 0.5f, 64, 4.0f, 0.6f, -1090519040),
    WEB(2.0f, 0.0f, 240, 0.8f, 76, 6.0f, 0.95f, -1);

    public final Hook hook;
    public final Rope rope;
    public final Launcher launcher;

    private HookType(float hookStrength, float hookDamage, int durability, float reelingSpeed, int ropeMaxLength, float ropeWidth, float ropeElasticity, int ropeColorARGB) {
        Main mod = Main.instance;
        Path configDir = mod.getConfig().getConfigDir();
        UnitConfig hookConfig = new UnitConfig(configDir, "hooks", this.func_176610_l());
        this.hook = new Hook(mod, hookConfig, this, hookStrength, hookDamage, hookStrength);
        UnitConfig launcherConfig = new UnitConfig(configDir, "launchers", this.func_176610_l());
        this.rope = new Rope((ForgeConfig)launcherConfig, ropeMaxLength, ropeWidth, ropeElasticity, ColorARGB.from((int)ropeColorARGB));
        float boostStrength = 1.0f;
        this.launcher = new Launcher(mod, this.func_176610_l(), launcherConfig, this, durability, reelingSpeed, boostStrength);
        hookConfig.save();
        launcherConfig.save();
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        HashMap<String, Hook> hookMap = new HashMap<String, Hook>();
        HashMap<String, Launcher> launcherMap = new HashMap<String, Launcher>();
        for (HookType element : HookType.values()) {
            hookMap.put("hook" + element.name().toLowerCase(Locale.ROOT), element.hook);
            launcherMap.put("hooklauncher" + element.name().toLowerCase(Locale.ROOT), element.launcher);
        }
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String oldName = mapping.key.func_110623_a().toLowerCase(Locale.ROOT);
            Hook hook = (Hook)((Object)hookMap.get(oldName));
            Launcher launcher = (Launcher)((Object)launcherMap.get(oldName));
            if (hook != null) {
                mapping.remap((IForgeRegistryEntry)hook);
            }
            if (launcher == null) continue;
            mapping.remap((IForgeRegistryEntry)launcher);
        }
    }

    public String func_176610_l() {
        return this.getLowerCase(this.name());
    }
}

