/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.minimallycorrect.tickprofiler.minecraft.TickProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.CollectionsUtil;

public class LagSpikeProfiler
extends Profile {
    private static final AtomicBoolean running = new AtomicBoolean();
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final int lagSpikeMillis = 200;
    private static final long lagSpikeNanoSeconds = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final boolean ALL_THREADS = Boolean.parseBoolean(System.getProperty("TickProfiler.allThreads", "false"));
    private boolean detected;

    private static void printThreadDump(StringBuilder sb) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
        if (deadlockedThreads == null) {
            TreeMap<String, String> sortedThreads = LagSpikeProfiler.sortedThreads(threadMXBean);
            sb.append(CollectionsUtil.join(sortedThreads.values(), "\n"));
        } else {
            ThreadInfo[] infos = threadMXBean.getThreadInfo(deadlockedThreads, true, true);
            sb.append("Definitely deadlocked: \n");
            for (ThreadInfo threadInfo : infos) {
                sb.append(LagSpikeProfiler.toString(threadInfo, true)).append('\n');
            }
        }
    }

    private static TreeMap<String, String> sortedThreads(ThreadMXBean threadMXBean) {
        ThreadInfo[] t;
        LoadingCache threads = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ThreadInfo>>(){

            public List<ThreadInfo> load(String key) throws Exception {
                return new ArrayList<ThreadInfo>();
            }
        });
        boolean allThreads = ALL_THREADS;
        for (ThreadInfo thread : t = threadMXBean.dumpAllThreads(allThreads, allThreads)) {
            String info;
            if (!allThreads && !LagSpikeProfiler.includeThread(thread) || (info = LagSpikeProfiler.toString(thread, false)) == null) continue;
            ((List)threads.getUnchecked((Object)info)).add(thread);
        }
        TreeMap<String, String> sortedThreads = new TreeMap<String, String>();
        for (Map.Entry entry : threads.asMap().entrySet()) {
            List threadInfoList = (List)entry.getValue();
            ThreadInfo lowest = null;
            for (ThreadInfo threadInfo : threadInfoList) {
                if (lowest != null && threadInfo.getThreadName().toLowerCase().compareTo(lowest.getThreadName().toLowerCase()) >= 0) continue;
                lowest = threadInfo;
            }
            List<String> threadNameList = CollectionsUtil.newList(threadInfoList, ThreadInfo::getThreadName);
            Collections.sort(threadNameList);
            if (lowest == null) continue;
            sortedThreads.put(lowest.getThreadName(), '\"' + CollectionsUtil.join(threadNameList, "\", \"") + "\" " + (String)entry.getKey());
        }
        return sortedThreads;
    }

    private static boolean includeThread(ThreadInfo thread) {
        return thread.getThreadName().toLowerCase().startsWith("server thread");
    }

    private static String toString(ThreadInfo threadInfo, boolean name) {
        if (threadInfo == null) {
            return null;
        }
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        if (stackTrace == null) {
            stackTrace = EMPTY_STACK_TRACE;
        }
        StringBuilder sb = new StringBuilder();
        if (name) {
            sb.append('\"').append(threadInfo.getThreadName()).append('\"').append(" Id=").append(threadInfo.getThreadId()).append(' ');
        }
        sb.append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        int run = 0;
        sb.append('\n');
        for (int i = 0; i < stackTrace.length; ++i) {
            String steString = stackTrace[i].toString();
            if (steString.contains(".run(")) {
                ++run;
            }
            sb.append("\tat ").append(steString);
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo mi = monitorInfoArray[j];
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(mi);
                sb.append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ").append(li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return run <= 2 && sb.indexOf("at java.util.concurrent.LinkedBlockingQueue.take(") != -1 ? null : sb.toString();
    }

    @Override
    protected AtomicBoolean getRunning() {
        return running;
    }

    @Override
    public void start() {
        this.start(null, null, null, 1 + Math.min(1000, 33), this::checkForLagSpikes);
    }

    private void checkForLagSpikes() {
        long deadTime = System.nanoTime() - TickProfiler.lastTickTime;
        if (deadTime < lagSpikeNanoSeconds) {
            this.detected = false;
            return;
        }
        if (this.detected) {
            return;
        }
        this.detected = true;
        this.handleLagSpike(deadTime);
    }

    private void handleLagSpike(long deadNanoSeconds) {
        StringBuilder sb = new StringBuilder();
        sb.append("The server appears to have ").append("lag spiked.").append("\nLast tick ").append((float)deadNanoSeconds / 1.0E9f).append("s ago.");
        LagSpikeProfiler.printThreadDump(sb);
        this.targets.forEach(it -> it.sendMessage(sb.toString()));
        Thread.sleep(2000L);
    }
}

