/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.util.stringfillers;

import java.util.HashMap;
import java.util.HashSet;
import org.minimallycorrect.tickprofiler.util.ChatFormat;
import org.minimallycorrect.tickprofiler.util.stringfillers.StringFiller;

class ChatStringFiller
extends StringFiller {
    private static final double DEFAULT_LENGTH = 1.5;
    private static final double MAX_GAP = 1.25;
    private static final HashMap<Character, Double> SIZE_MAP = new HashMap<Character, Double>(){
        {
            this.put(Character.valueOf('i'), 0.5);
            this.put(Character.valueOf('k'), 1.25);
            this.put(Character.valueOf('t'), 1.0);
            this.put(Character.valueOf('f'), 1.25);
            this.put(Character.valueOf('('), 1.25);
            this.put(Character.valueOf(')'), 1.25);
            this.put(Character.valueOf('<'), 1.25);
            this.put(Character.valueOf('>'), 1.25);
            this.put(Character.valueOf('{'), 1.25);
            this.put(Character.valueOf('}'), 1.25);
            this.put(Character.valueOf(','), 0.5);
            this.put(Character.valueOf('.'), 0.5);
            this.put(Character.valueOf('['), 1.0);
            this.put(Character.valueOf(']'), 1.0);
            this.put(Character.valueOf('I'), 1.0);
            this.put(Character.valueOf('|'), 0.5);
            this.put(Character.valueOf('*'), 1.25);
            this.put(Character.valueOf('\"'), 1.25);
            this.put(Character.valueOf('|'), 0.5);
            this.put(Character.valueOf('!'), 0.5);
            this.put(Character.valueOf(':'), 0.5);
            this.put(Character.valueOf('l'), 0.75);
            this.put(Character.valueOf('.'), 0.5);
            this.put(Character.valueOf('\''), 0.75);
            this.put(Character.valueOf(' '), 1.0);
            this.put(Character.valueOf('\"'), 1.25);
            this.put(Character.valueOf('`'), 0.5);
            this.put(Character.valueOf('\u0000'), 0.0);
            this.put(Character.valueOf('\u278a'), 0.5);
            this.put(Character.valueOf('\u278b'), 0.75);
            this.put(Character.valueOf(' '), 1.0);
            this.put(Character.valueOf('\u278c'), 1.25);
            this.put(Character.valueOf('\u2500'), 1.25);
            this.put(Character.valueOf('\u2502'), 0.25);
            this.put(Character.valueOf('\u250c'), 0.75);
            this.put(Character.valueOf('\u2510'), 0.75);
            this.put(Character.valueOf('\u2514'), 0.75);
            this.put(Character.valueOf('\u2518'), 0.75);
            this.put(Character.valueOf('\u2550'), 1.25);
            this.put(Character.valueOf('\u2551'), 0.5);
            this.put(Character.valueOf('\u2554'), 0.75);
            this.put(Character.valueOf('\u2560'), 0.75);
            this.put(Character.valueOf('\u255a'), 0.75);
            this.put(Character.valueOf('\u2557'), 1.0);
            this.put(Character.valueOf('\u2563'), 1.0);
            this.put(Character.valueOf('\u255d'), 1.0);
            this.put(Character.valueOf('\u2591'), 2.0);
        }
    };
    private static final HashSet<Character> FILL_CHARS = new HashSet<Character>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Character.valueOf('\u278a'));
            this.add(Character.valueOf('\u278b'));
            this.add(Character.valueOf(' '));
            this.add(Character.valueOf('\u278c'));
        }
    };

    ChatStringFiller() {
    }

    private static Character findCustom(double gapLen) {
        HashSet<Character> gapStrs = new HashSet<Character>(FILL_CHARS);
        double bestFitLen = -1.0;
        Character bestFitStr = null;
        for (Character gapStr : gapStrs) {
            double gapStrLen = SIZE_MAP.get(gapStr);
            if (!(gapLen - gapStrLen >= 0.0) || !(gapStrLen > bestFitLen)) continue;
            bestFitLen = gapStrLen;
            bestFitStr = gapStr;
        }
        return bestFitStr;
    }

    @Override
    public String fill(String str, double reqLength) {
        double gapLength;
        char[] chars = str.toCharArray();
        StringBuilder result = new StringBuilder();
        double length = 0.0;
        for (int i = 0; i < chars.length; ++i) {
            Double charLength = SIZE_MAP.get(Character.valueOf(chars[i]));
            if (charLength == null) {
                charLength = 1.5;
            }
            if (length + charLength > reqLength) break;
            result.append(chars[i]);
            if (chars[i] == '\u00a7' || i > 0 && chars[i - 1] == '\u00a7') continue;
            length += charLength.doubleValue();
        }
        Character fillChar = Character.valueOf(' ');
        double fillLength = 1.0;
        while (!((gapLength = reqLength - length) <= 0.0)) {
            if (gapLength <= 1.25) {
                fillChar = ChatStringFiller.findCustom(gapLength);
                if (fillChar == null) break;
                result.append(fillChar);
                break;
            }
            result.append(fillChar);
            length += fillLength;
        }
        return result.toString().replace("\u278a", (Object)((Object)ChatFormat.DARK_GRAY) + "`" + (Object)((Object)ChatFormat.RESET)).replace("\u278b", (Object)((Object)ChatFormat.DARK_GRAY) + String.valueOf((Object)ChatFormat.BOLD) + '`' + (Object)((Object)ChatFormat.RESET)).replace("\u278c", (Object)((Object)ChatFormat.DARK_GRAY) + String.valueOf((Object)ChatFormat.BOLD) + ' ' + (Object)((Object)ChatFormat.RESET));
    }

    @Override
    public double getLength(String str) {
        char[] chars = str.toCharArray();
        double length = 0.0;
        for (int i = 0; i < chars.length; ++i) {
            Double charLength = SIZE_MAP.get(Character.valueOf(chars[i]));
            if (charLength == null) {
                charLength = 1.5;
            }
            if (chars[i] == '\u00a7' || i > 0 && chars[i - 1] == '\u00a7') continue;
            length += charLength.doubleValue();
        }
        return length;
    }
}

