/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureDescriptionList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureTypeList;
import com.lycanitesmobs.client.gui.beastiary.lists.SubspeciesList;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.Subspecies;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class CreaturesBeastiaryScreen
extends BeastiaryScreen {
    public CreatureTypeList creatureTypeList;
    public CreatureList creatureList;
    public SubspeciesList subspeciesList;
    public CreatureDescriptionList descriptionList;

    public static void openToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.BEASTIARY.id, player.func_130014_f_(), (int)GuiHandler.Beastiary.CREATURES.id, 0, 0);
        }
    }

    public CreaturesBeastiaryScreen(EntityPlayer player) {
        super(player);
    }

    @Override
    public String getTitle() {
        if (this.creatureList != null && this.playerExt.selectedCreature != null) {
            return "";
        }
        if (this.creatureTypeList != null && this.playerExt.selectedCreatureType != null) {
            return this.playerExt.selectedCreatureType.getTitle();
        }
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            LanguageManager.translate("gui.beastiary.creatures.empty.title");
        }
        return LanguageManager.translate("gui.beastiary.creatures");
    }

    @Override
    public void initControls() {
        super.initControls();
        this.creatureTypeList = new CreatureTypeList(this, this.colLeftWidth, this.colLeftHeight, this.colLeftY, this.colLeftY + this.colLeftHeight, this.colLeftX);
        int selectionListsWidth = this.getScaledX(0.125f);
        int creatureListY = this.colRightY;
        int creatureListHeight = Math.round((float)this.colRightHeight * 0.6f);
        this.creatureList = new CreatureList(CreatureList.Type.KNOWLEDGE, this, this.creatureTypeList, selectionListsWidth, creatureListHeight, creatureListY, creatureListY + creatureListHeight, this.colRightX);
        int subspeciesListY = creatureListY + 2 + creatureListHeight;
        int subspeciesListHeight = Math.round((float)this.colRightHeight * 0.4f) - 2;
        this.subspeciesList = new SubspeciesList(this, false, selectionListsWidth, subspeciesListHeight, subspeciesListY, subspeciesListY + subspeciesListHeight, this.colRightX);
        int newLine = this.getFontRenderer().func_78267_b("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", this.colRightWidth - selectionListsWidth) + 2;
        int descriptionListY = this.colRightY + newLine * 3;
        this.descriptionList = new CreatureDescriptionList(this, this.colRightWidth - selectionListsWidth, this.colRightHeight, descriptionListY, this.colRightY + this.colRightHeight, this.colRightX + selectionListsWidth + 2);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        super.updateControls(mouseX, mouseY, partialTicks);
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            return;
        }
        this.creatureTypeList.drawScreen(mouseX, mouseY, partialTicks);
        if (this.playerExt.selectedCreatureType != null) {
            this.creatureList.drawScreen(mouseX, mouseY, partialTicks);
            this.subspeciesList.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        int marginX = this.getScaledX(0.125f) + 8;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.getBeastiary().creatureKnowledgeList.isEmpty()) {
            String text = LanguageManager.translate("gui.beastiary.creatures.empty.info");
            this.drawSplitString(text, this.colRightX, nextY += 20, this.colRightWidth, 0xFFFFFF, true);
            return;
        }
        if (this.playerExt.selectedCreature != null) {
            Subspecies subspecies = this.playerExt.selectedCreature.getSubspecies(this.playerExt.selectedSubspecies);
            this.renderCreature(this.playerExt.selectedCreature, this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + 100, mouseX, mouseY, partialTicks);
            CreatureInfo creatureInfo = this.playerExt.selectedCreature;
            CreatureKnowledge creatureKnowledge = this.playerExt.beastiary.getCreatureKnowledge(this.playerExt.selectedCreature.getName());
            String text = "\u00a7l" + LanguageManager.translate("creature.stat.element") + ": \u00a7r";
            text = text + (creatureInfo.elements != null ? creatureInfo.getElementNames(subspecies) : "None");
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            nextY += 2 + this.getFontRenderer().func_78267_b(text, width);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.cost") + ": \u00a7r";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            this.drawLevel(creatureInfo, AssetManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
            nextY += 2 + this.getFontRenderer().func_78267_b(text, width);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.knowledge") + ": \u00a7r";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            this.drawBar(AssetManager.getTexture("GUIPetSpiritEmpty"), nextX + this.getFontRenderer().func_78256_a(text), nextY, 0.0f, 9.0f, 9.0f, 3, 10);
            this.drawBar(AssetManager.getTexture("GUIPetSpiritUsed"), nextX + this.getFontRenderer().func_78256_a(text), nextY, 0.0f, 9.0f, 9.0f, creatureKnowledge.rank, 10);
            this.descriptionList.creatureKnowledge = creatureKnowledge;
            this.descriptionList.drawScreen(mouseX, mouseY, partialTicks);
        } else if (this.playerExt.selectedCreatureType != null) {
            String text = LanguageManager.translate("gui.beastiary.creatures.descovered") + ": ";
            text = text + this.playerExt.getBeastiary().getCreaturesDescovered(this.playerExt.selectedCreatureType);
            text = text + "/" + this.playerExt.selectedCreatureType.creatures.size();
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)(nextY += 20), 0xFFFFFF, true);
        } else {
            String text = LanguageManager.translate("gui.beastiary.creatures.select");
            this.drawSplitString(text, this.colRightX, nextY += 20, this.colRightWidth, 0xFFFFFF, true);
        }
    }

    @Override
    protected void func_146284_a(GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
    }
}

