/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBeholder
extends RideableCreatureEntity {
    public boolean griefing = true;

    public EntityBeholder(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(20);
        this.solidCollision = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.25).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76419_f)) {
            rider.func_184589_d(MobEffects.field_76419_f);
        }
        if (rider.func_70644_a((Potion)ObjectManager.getEffect("weight"))) {
            rider.func_184589_d((Potion)ObjectManager.getEffect("weight"));
        }
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        super.onDamage(damageSrc, damage);
        Entity damageEntity = damageSrc.func_76346_g();
        if (damageEntity != null && ("mob".equals(damageSrc.field_76373_n) || "player".equals(damageSrc.field_76373_n)) && damageEntity instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)damageEntity;
            ArrayList<Potion> goodEffects = new ArrayList<Potion>();
            for (PotionEffect effect : targetLiving.func_70651_bq()) {
                if (!ObjectLists.inEffectList("buffs", effect.func_188419_a())) continue;
                goodEffects.add(effect.func_188419_a());
            }
            if (goodEffects.size() > 0 && this.func_70681_au().nextBoolean()) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_184589_d((Potion)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_184589_d((Potion)goodEffects.get(0));
                }
                float leeching = damage * 1.1f;
                this.func_70691_i(leeching);
            }
        }
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("arcanelaserstorm", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityBeholder) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    @Override
    public double getMountedZOffset() {
        return (double)this.field_70130_N * -0.2;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("arcanelaserstorm");
            if (projectileInfo != null) {
                BaseProjectileEntity projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)player);
                this.func_130014_f_().func_72838_d((Entity)projectile);
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.triggerAttackCooldown();
            }
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 10.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.isAttackOnCooldown()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }
}

