/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityTremor
extends TameableCreatureEntity
implements IMob {
    public int explosionStrength = 1;

    public EntityTremor(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void loadCreatureFlags() {
        this.explosionStrength = this.creatureInfo.getFlag("explosionStrength", this.explosionStrength);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.isRareVariant() && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        boolean damageTerrain;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        int explosionStrength = Math.max(1, this.explosionStrength);
        boolean bl = damageTerrain = this.explosionStrength > 0 && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
        if (this.isPetType("familiar")) {
            explosionStrength = 1;
            damageTerrain = false;
        }
        this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionStrength, damageTerrain);
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (source.func_94541_c()) {
            this.func_70691_i(damage);
            return false;
        }
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityWither) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean func_70687_e(PotionEffect effectInstance) {
        if (effectInstance.func_188419_a() == MobEffects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean canBeTargetedBy(EntityLivingBase entity) {
        if (entity instanceof EntityWither) {
            return false;
        }
        return super.canBeTargetedBy(entity);
    }
}

