/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;

public class FindMasterGoal
extends TargetingGoal {
    private Class targetClass = EntityLiving.class;
    private boolean tameTargeting = false;
    private int targetChance = 0;

    public FindMasterGoal(BaseCreatureEntity setHost) {
        super(setHost);
    }

    public FindMasterGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public FindMasterGoal setChance(int setChance) {
        this.targetChance = setChance;
        return this;
    }

    public FindMasterGoal setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        return this;
    }

    public FindMasterGoal setSightCheck(boolean setSightCheck) {
        this.checkSight = setSightCheck;
        return this;
    }

    public FindMasterGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public FindMasterGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public FindMasterGoal setRange(double setDist) {
        this.targetingRange = setDist;
        return this;
    }

    @Override
    protected EntityLivingBase getTarget() {
        return this.host.getMasterTarget();
    }

    @Override
    protected void setTarget(EntityLivingBase newTarget) {
        this.host.setMasterTarget(newTarget);
    }

    @Override
    protected boolean isValidTarget(EntityLivingBase target) {
        if (this.targetClass != null && !this.targetClass.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (target instanceof EntityAnimal && ((EntityAnimal)target).func_70874_b() < 0) {
            return false;
        }
        if (target instanceof AgeableCreatureEntity && ((AgeableCreatureEntity)target).getGrowingAge() < 0) {
            return false;
        }
        return this.tameTargeting || !this.host.isTamed();
    }

    @Override
    protected double getTargetDistance() {
        if (this.targetingRange > 0.0) {
            return this.targetingRange;
        }
        IAttributeInstance attributeinstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeinstance.func_111126_e();
    }

    public boolean func_75250_a() {
        if (this.host.updateTick % 20L != 0L) {
            return false;
        }
        if (this.targetChance > 0 && this.host.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        return this.target != null;
    }
}

