/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.network.MessageBeastiary;
import com.lycanitesmobs.core.network.MessageCreatureKnowledge;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class Beastiary {
    public ExtendedPlayer extendedPlayer;
    public Map<String, CreatureKnowledge> creatureKnowledgeList = new HashMap<String, CreatureKnowledge>();

    public Beastiary(ExtendedPlayer extendedPlayer) {
        this.extendedPlayer = extendedPlayer;
    }

    public int addCreatureKnowledge(CreatureKnowledge newKnowledge) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(newKnowledge.creatureName);
        if (creatureInfo == null) {
            return 0;
        }
        if (creatureInfo.dummy) {
            return 0;
        }
        CreatureKnowledge currentKnowledge = this.getCreatureKnowledge(creatureInfo.getName());
        if (currentKnowledge != null) {
            if (currentKnowledge.rank >= newKnowledge.rank) {
                return 0;
            }
            int rankIncrease = newKnowledge.rank - currentKnowledge.rank;
            currentKnowledge.rank = newKnowledge.rank;
            return rankIncrease;
        }
        this.creatureKnowledgeList.put(newKnowledge.creatureName, newKnowledge);
        return newKnowledge.rank;
    }

    public boolean discoverCreature(Entity entity, int rank, boolean knownMessage) {
        if (!(entity instanceof BaseCreatureEntity)) {
            if (!this.extendedPlayer.player.func_130014_f_().field_72995_K) {
                this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.beastiary.unknown")));
            }
            return false;
        }
        if (entity instanceof FearEntity) {
            return false;
        }
        CreatureInfo creatureInfo = ((BaseCreatureEntity)entity).creatureInfo;
        CreatureKnowledge newKnowledge = new CreatureKnowledge(this.extendedPlayer.getBeastiary(), creatureInfo.getName(), rank);
        int rankChange = this.extendedPlayer.getBeastiary().addCreatureKnowledge(newKnowledge);
        if (rankChange <= 0) {
            if (knownMessage) {
                this.sendKnownMessage(newKnowledge);
            }
            return false;
        }
        this.extendedPlayer.player.func_71064_a(ObjectManager.getStat(creatureInfo.name + ".learn"), 1);
        this.sendAddedMessage(newKnowledge);
        this.sendToClient(newKnowledge);
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                entity.func_130014_f_().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, entity.field_70163_u + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, entity.field_70161_v + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return true;
    }

    public void sendAddedMessage(CreatureKnowledge creatureKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K || !CreatureManager.getInstance().config.beastiaryKnowledgeMessages) {
            return;
        }
        CreatureInfo creatureInfo = creatureKnowledge.getCreatureInfo();
        String message = LanguageManager.translate("message.beastiary.new");
        message = message.replace("%creature%", creatureInfo.getTitle());
        message = message.replace("%rank%", "" + creatureKnowledge.rank);
        this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(message));
        if (creatureInfo.isSummonable()) {
            String summonMessage = LanguageManager.translate("message.beastiary.summonable");
            if (creatureKnowledge.rank >= 3) {
                summonMessage = LanguageManager.translate("message.beastiary.summonable.skins");
            } else if (creatureKnowledge.rank == 2) {
                summonMessage = LanguageManager.translate("message.beastiary.summonable.colors");
            }
            summonMessage = summonMessage.replace("%creature%", creatureInfo.getTitle());
            this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(summonMessage));
        }
    }

    public void sendKnownMessage(CreatureKnowledge creatureKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            return;
        }
        CreatureInfo creatureInfo = creatureKnowledge.getCreatureInfo();
        CreatureKnowledge currentKnowledge = this.extendedPlayer.getBeastiary().getCreatureKnowledge(creatureInfo.getName());
        String message = LanguageManager.translate("message.beastiary.known");
        message = message.replace("%creature%", creatureInfo.getTitle());
        message = message.replace("%rank%", "" + currentKnowledge.rank);
        this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    @Nullable
    public CreatureKnowledge getCreatureKnowledge(String creatureName) {
        if (!this.creatureKnowledgeList.containsKey(creatureName)) {
            return null;
        }
        return this.creatureKnowledgeList.get(creatureName);
    }

    public boolean hasKnowledgeRank(String creatureName, int rank) {
        CreatureKnowledge creatureKnowledge = this.getCreatureKnowledge(creatureName);
        if (creatureKnowledge == null) {
            return false;
        }
        return creatureKnowledge.rank >= rank;
    }

    public int getCreaturesDescovered(CreatureType creatureType) {
        if (this.creatureKnowledgeList.size() == 0) {
            return 0;
        }
        int creaturesDescovered = 0;
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            if (creatureKnowledgeEntry.getValue() == null || creatureKnowledgeEntry.getValue().getCreatureInfo().creatureType != creatureType) continue;
            ++creaturesDescovered;
        }
        return creaturesDescovered;
    }

    public Map<Integer, String> getSummonableList() {
        HashMap<Integer, String> minionList = new HashMap<Integer, String>();
        int minionIndex = 0;
        for (String minionName : this.creatureKnowledgeList.keySet()) {
            if (!SummonSet.isSummonableCreature(minionName)) continue;
            minionList.put(minionIndex++, minionName);
        }
        return minionList;
    }

    public void sendToClient(CreatureKnowledge newKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessageCreatureKnowledge message = new MessageCreatureKnowledge(newKnowledge);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void sendAllToClient() {
        LycanitesMobs.logDebug("Packets", "Sending all beastiary to client.");
        MessageBeastiary message = new MessageBeastiary(this);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("CreatureKnowledge")) {
            return;
        }
        this.creatureKnowledgeList.clear();
        NBTTagList knowledgeList = nbtTagCompound.func_150295_c("CreatureKnowledge", 10);
        for (int i = 0; i < knowledgeList.func_74745_c(); ++i) {
            NBTTagCompound nbtKnowledge = knowledgeList.func_150305_b(i);
            if (!nbtKnowledge.func_74764_b("CreatureName")) continue;
            String creatureName = nbtKnowledge.func_74779_i("CreatureName");
            int rank = 0;
            if (nbtKnowledge.func_74764_b("Rank")) {
                rank = nbtKnowledge.func_74762_e("Rank");
            } else if (nbtKnowledge.func_74764_b("Completion")) {
                rank = 2;
            }
            CreatureKnowledge creatureKnowledge = new CreatureKnowledge(this, creatureName, rank);
            this.addCreatureKnowledge(creatureKnowledge);
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList knowledgeList = new NBTTagList();
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            CreatureKnowledge creatureKnowledge = creatureKnowledgeEntry.getValue();
            NBTTagCompound nbtKnowledge = new NBTTagCompound();
            nbtKnowledge.func_74778_a("CreatureName", creatureKnowledge.creatureName);
            nbtKnowledge.func_74768_a("Rank", creatureKnowledge.rank);
            knowledgeList.func_74742_a((NBTBase)nbtKnowledge);
        }
        nbtTagCompound.func_74782_a("CreatureKnowledge", (NBTBase)knowledgeList);
    }
}

