/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CreatureSpawn {
    public boolean enabled = true;
    public boolean disableVariants = false;
    public List<String> spawners = new ArrayList<String>();
    public List<EnumCreatureType> vanillaSpawnerTypes = new ArrayList<EnumCreatureType>();
    public int[] dimensionIds;
    public String dimensionListType = "whitelist";
    public List<String> biomeTags = new ArrayList<String>();
    public List<Biome> biomesFromTags = null;
    public List<String> biomeIds = new ArrayList<String>();
    public List<Biome> biomes = null;
    public boolean ignoreBiome = false;
    public int spawnWeight = 8;
    public int dungeonWeight = 200;
    public int spawnAreaLimit = 5;
    public int spawnGroupMin = 1;
    public int spawnGroupMax = 3;
    public boolean spawnsInLight = false;
    public boolean spawnsInDark = true;
    public double worldDayMin = -1.0;
    public boolean despawnNatural = true;
    public boolean despawnForced = false;

    public void loadFromJSON(CreatureInfo creatureInfo, JsonObject json) {
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("disableSubspecies")) {
            this.disableVariants = json.get("disableSubspecies").getAsBoolean();
        }
        this.spawners.clear();
        this.vanillaSpawnerTypes.clear();
        if (json.has("spawners")) {
            this.spawners = JSONHelper.getJsonStrings(json.get("spawners").getAsJsonArray());
            for (String spawner : this.spawners) {
                LycanitesMobs.logDebug("Creature", "Adding " + creatureInfo.getName() + " to " + spawner + " global spawn list.");
                SpawnerMobRegistry.createSpawn(creatureInfo, spawner);
                if ("monster".equalsIgnoreCase(spawner)) {
                    this.vanillaSpawnerTypes.add(EnumCreatureType.MONSTER);
                    continue;
                }
                if ("creature".equalsIgnoreCase(spawner)) {
                    this.vanillaSpawnerTypes.add(EnumCreatureType.CREATURE);
                    continue;
                }
                if ("watercreature".equalsIgnoreCase(spawner)) {
                    this.vanillaSpawnerTypes.add(EnumCreatureType.WATER_CREATURE);
                    continue;
                }
                if (!"ambient".equalsIgnoreCase(spawner)) continue;
                this.vanillaSpawnerTypes.add(EnumCreatureType.AMBIENT);
            }
        }
        if (json.has("dimensionIds")) {
            JsonArray jsonArray = json.get("dimensionIds").getAsJsonArray();
            this.dimensionIds = new int[jsonArray.size()];
            Iterator jsonIterator = jsonArray.iterator();
            int i = 0;
            while (jsonIterator.hasNext()) {
                this.dimensionIds[i] = ((JsonElement)jsonIterator.next()).getAsInt();
                ++i;
            }
        }
        if (json.has("dimensionListType")) {
            this.dimensionListType = json.get("dimensionListType").getAsString();
        }
        if (json.has("ignoreBiome")) {
            this.ignoreBiome = json.get("ignoreBiome").getAsBoolean();
        }
        if (json.has("biomeTags")) {
            this.biomeTags.clear();
            this.biomesFromTags = null;
            this.biomeTags = JSONHelper.getJsonStrings(json.get("biomeTags").getAsJsonArray());
        } else if (json.has("biomes")) {
            this.biomeTags.clear();
            this.biomesFromTags = null;
            this.biomeTags = JSONHelper.getJsonStrings(json.get("biomes").getAsJsonArray());
        }
        if (json.has("biomeIds")) {
            this.biomeIds.clear();
            this.biomes = null;
            this.biomeIds = JSONHelper.getJsonStrings(json.get("biomeIds").getAsJsonArray());
        }
        if (json.has("spawnWeight")) {
            this.spawnWeight = json.get("spawnWeight").getAsInt();
        }
        if (json.has("dungeonWeight")) {
            this.dungeonWeight = json.get("dungeonWeight").getAsInt();
        }
        if (json.has("spawnAreaLimit")) {
            this.spawnAreaLimit = json.get("spawnAreaLimit").getAsInt();
        }
        if (json.has("spawnGroupMin")) {
            this.spawnGroupMin = json.get("spawnGroupMin").getAsInt();
        }
        if (json.has("spawnGroupMax")) {
            this.spawnGroupMax = json.get("spawnGroupMax").getAsInt();
        }
        if (json.has("spawnsInLight")) {
            this.spawnsInLight = json.get("spawnsInLight").getAsBoolean();
        }
        if (json.has("spawnsInDark")) {
            this.spawnsInDark = json.get("spawnsInDark").getAsBoolean();
        }
        if (json.has("worldDayMin")) {
            this.worldDayMin = json.get("worldDayMin").getAsInt();
        }
        if (json.has("despawnNatural")) {
            this.despawnNatural = json.get("despawnNatural").getAsBoolean();
        }
        if (json.has("despawnForced")) {
            this.despawnForced = json.get("despawnForced").getAsBoolean();
        }
    }

    public void registerVanillaSpawns(CreatureInfo creatureInfo) {
        LycanitesMobs.logDebug("MobSetup", "========== Post Init Setup: " + creatureInfo.name + " ==========");
        ArrayList<Biome> vanillaBiomes = new ArrayList<Biome>();
        if (this.biomesFromTags == null) {
            this.biomesFromTags = JSONHelper.getBiomesFromTags(this.biomeTags);
        }
        vanillaBiomes.addAll(this.biomesFromTags);
        if (this.biomes == null) {
            this.biomes = JSONHelper.getBiomes(this.biomeIds);
        }
        vanillaBiomes.addAll(this.biomes);
        if (!CreatureManager.getInstance().spawnConfig.disableAllSpawning && creatureInfo.enabled && this.enabled && this.spawnWeight > 0 && this.spawnGroupMax > 0 && CreatureManager.getInstance().spawnConfig.spawnWeightScale > 0.0) {
            int vanillaWeight = (int)Math.ceil(CreatureManager.getInstance().spawnConfig.spawnWeightScale * (double)this.spawnWeight);
            block0: for (EnumCreatureType creatureType : this.vanillaSpawnerTypes) {
                EntityRegistry.addSpawn(creatureInfo.entityClass, (int)vanillaWeight, (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)creatureType, (Biome[])this.biomesFromTags.toArray(new Biome[this.biomesFromTags.size()]));
                for (Biome biome : vanillaBiomes) {
                    if (biome == Biomes.field_76778_j) {
                        EntityRegistry.addSpawn(creatureInfo.entityClass, (int)(vanillaWeight * 10), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)creatureType, (Biome[])new Biome[]{biome});
                        continue block0;
                    }
                    LycanitesMobs.logDebug("MobSetup", "Vanilla Spawn Biome Added: " + biome);
                }
            }
            LycanitesMobs.logDebug("MobSetup", "Vanilla Spawns Added - Weight: " + vanillaWeight);
        }
        if (!CreatureManager.getInstance().spawnConfig.disableDungeonSpawners && this.dungeonWeight > 0) {
            DungeonHooks.addDungeonMob((ResourceLocation)creatureInfo.getResourceLocation(), (int)this.dungeonWeight);
            LycanitesMobs.logDebug("MobSetup", "Dungeon Spawn Added - Weight: " + this.dungeonWeight);
        }
    }

    public boolean isAllowedDimension(World world) {
        if (world == null || world.field_73011_w == null) {
            LycanitesMobs.logDebug("MobSpawns", "No world or dimension spawn settings were found, defaulting to valid.");
            return true;
        }
        if (!CreatureManager.getInstance().spawnConfig.isAllowedGlobal(world)) {
            return false;
        }
        if (this.dimensionIds.length == 0) {
            return true;
        }
        for (int dimensionId : this.dimensionIds) {
            if (world.field_73011_w.getDimension() != dimensionId) continue;
            LycanitesMobs.logDebug("MobSpawns", "Dimension is in " + this.dimensionListType + ".");
            return this.dimensionListType.equalsIgnoreCase("whitelist");
        }
        LycanitesMobs.logDebug("MobSpawns", "Dimension was not in " + this.dimensionListType + ".");
        return this.dimensionListType.equalsIgnoreCase("blacklist");
    }

    public boolean isValidBiome(Biome biome) {
        if (this.ignoreBiome) {
            return true;
        }
        if (!this.biomeTags.isEmpty()) {
            if (this.biomesFromTags == null) {
                this.biomesFromTags = JSONHelper.getBiomesFromTags(this.biomeTags);
            }
            if (this.biomesFromTags.contains(biome)) {
                return true;
            }
        }
        if (!this.biomeIds.isEmpty()) {
            if (this.biomes == null) {
                this.biomes = JSONHelper.getBiomes(this.biomeIds);
            }
            if (this.biomes.contains(biome)) {
                return true;
            }
        }
        return false;
    }
}

