/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.item.ItemBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ChargeItem
extends ItemBase {
    public static int CHARGE_EXPERIENCE = 50;
    public ProjectileInfo projectileInfo;

    public ChargeItem(ProjectileInfo projectileInfo) {
        this.projectileInfo = projectileInfo;
        this.modInfo = LycanitesMobs.modInfo;
        if (this.projectileInfo != null) {
            this.itemName = projectileInfo.chargeItemName;
            LycanitesMobs.logDebug("Projectile", "Created Charge Item: " + projectileInfo.chargeItemName);
            this.setup();
        }
    }

    @Override
    public void setup() {
        this.setRegistryName(this.modInfo.modid, this.itemName);
        this.func_77655_b(this.itemName);
        this.func_77637_a(LycanitesMobs.chargesTab);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return this.getProjectileName() + " " + LanguageManager.translate("item.lycanitesmobs.charge");
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("-------------------\n" + description, DESCRIPTION_WIDTH);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a73" + formattedDescription);
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        return LanguageManager.translate("item.lycanitesmobs.charge.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        if (!this.getElements().isEmpty()) {
            String elements = LanguageManager.translate("item.lycanitesmobs.charge.elements") + " " + this.getElementNames();
            descriptions.add(elements);
        }
        String projectile = LanguageManager.translate("item.lycanitesmobs.charge.projectile") + " " + this.getProjectileName();
        descriptions.add(projectile);
        return descriptions;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            BaseProjectileEntity projectile = this.createProjectile(itemStack, world, player);
            if (projectile == null) {
                LycanitesMobs.logWarning("", "Failed to create projectile from Charge Item: " + this.itemName);
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
            }
            world.func_72838_d((Entity)projectile);
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
            this.playSound(world, player.func_180425_c(), projectile.getLaunchSound(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean onItemRightClickOnEntity(EntityPlayer player, Entity entity, ItemStack itemStack) {
        return !(entity instanceof TameableCreatureEntity) || ((TameableCreatureEntity)entity).getPlayerOwner() != player;
    }

    public BaseProjectileEntity createProjectile(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (this.projectileInfo == null) {
            return null;
        }
        return this.projectileInfo.createProjectile(world, (EntityLivingBase)entityPlayer);
    }

    public List<ElementInfo> getElements() {
        if (this.projectileInfo == null) {
            return new ArrayList<ElementInfo>();
        }
        return this.projectileInfo.elements;
    }

    public String getElementNames() {
        String elementNames = "";
        boolean firstElement = true;
        for (ElementInfo element : this.getElements()) {
            if (!firstElement) {
                elementNames = elementNames + ", ";
            }
            firstElement = false;
            elementNames = elementNames + element.getTitle();
        }
        return elementNames;
    }

    public String getProjectileName() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getTitle();
        }
        return LanguageManager.translate("item.lycanitesmobs.charge");
    }
}

