/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.MobEventSchedule;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MobEventManager
extends JSONLoader {
    protected static MobEventManager INSTANCE;
    public Map<String, MobEvent> mobEvents = new HashMap<String, MobEvent>();
    public List<MobEventSchedule> mobEventSchedules = new ArrayList<MobEventSchedule>();
    public boolean mobEventsEnabled = true;
    public boolean mobEventsRandom = false;
    public int defaultMobDuration = 12000;
    public int minEventsRandomDay = 0;
    public int minTicksUntilEvent = 72000;
    public int maxTicksUntilEvent = 144000;

    public static MobEventManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobEventManager();
        }
        return INSTANCE;
    }

    public void loadConfig() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.modInfo, "mobevents");
        config.setCategoryComment("Global", "These are various settings that apply to all events.");
        this.mobEventsEnabled = config.getBool("Global", "Mob Events Enabled", this.mobEventsEnabled, "Set to false to completely disable the entire event system for every world.");
        this.mobEventsRandom = config.getBool("Global", "Random Mob Events Enabled", this.mobEventsRandom, "Set to false to disable random mob events for every world.");
        this.defaultMobDuration = config.getInt("Global", "Default Mob Duration", this.defaultMobDuration, "The default temporary time applied to mobs spawned from events, where it will forcefully despawn after the specified time (in ticks). MobSpawns can override this.");
        this.minEventsRandomDay = config.getInt("Global", "Default Random Mob Events Day Minimum", this.minEventsRandomDay, "If random events are enabled, they wont occur until this day is reached. Set to 0 to have random events enabled from the start of a world.");
        this.minTicksUntilEvent = config.getInt("Global", "Default Min Ticks Until Random Event", this.minTicksUntilEvent, "Minimum time in ticks until a random event can occur. 20 Ticks = 1 Second.");
        this.maxTicksUntilEvent = config.getInt("Global", "Default Max Ticks Until Random Event", this.maxTicksUntilEvent, "Maximum time in ticks until a random event can occur. 20 Ticks = 1 Second.");
    }

    public void loadAllFromJSON(ModInfo groupInfo) {
        JsonObject scheduleJson;
        LycanitesMobs.logDebug("MobEvents", "Loading JSON Mob Events!");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> mobEventJSONs = new HashMap<String, JsonObject>();
        Path path = Utilities.getAssetPath(groupInfo.getClass(), groupInfo.modid, "mobevents");
        HashMap<String, JsonObject> defaultMobEventJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultMobEventJSONs, "name", "event");
        String configPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        File customDir = new File(configPath + "mobevents");
        customDir.mkdirs();
        path = customDir.toPath();
        HashMap<String, JsonObject> customMobEventJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customMobEventJSONs, "name", "event");
        this.writeDefaultJSONObjects(gson, defaultMobEventJSONs, customMobEventJSONs, mobEventJSONs, true, "mobevents");
        LycanitesMobs.logDebug("MobEvents", "Loading " + mobEventJSONs.size() + " Mob Events...");
        for (String spawnerJSONName : mobEventJSONs.keySet()) {
            try {
                JsonObject spawnerJSON = (JsonObject)mobEventJSONs.get(spawnerJSONName);
                LycanitesMobs.logDebug("MobEvents", "Loading Mob Event JSON: " + spawnerJSON);
                MobEvent mobEvent = new MobEvent();
                mobEvent.loadFromJSON(spawnerJSON);
                this.addMobEvent(mobEvent);
            }
            catch (JsonParseException e) {
                LycanitesMobs.logWarning("", "Parsing error loading JSON Mob Event: " + spawnerJSONName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "There was a problem loading JSON Mob Event: " + spawnerJSONName);
                e.printStackTrace();
            }
        }
        LycanitesMobs.logDebug("MobEvents", "Complete! " + this.mobEvents.size() + " JSON Mob Events Loaded In Total.");
        this.mobEventSchedules.clear();
        Path defaultSchedulePath = Utilities.getAssetPath(groupInfo.getClass(), groupInfo.modid, "mobeventschedule.json");
        JsonObject defaultScheduleJson = this.loadJsonObject(gson, defaultSchedulePath);
        File customScheduleFile = new File(configPath + "mobeventschedule.json");
        JsonObject customScheduleJson = null;
        if (customScheduleFile.exists()) {
            customScheduleJson = this.loadJsonObject(gson, customScheduleFile.toPath());
        }
        if ((scheduleJson = this.writeDefaultJSONObject(gson, "mobeventschedule", defaultScheduleJson, customScheduleJson)).has("schedules")) {
            JsonArray jsonArray = scheduleJson.get("schedules").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject scheduleEntryJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                MobEventSchedule mobEventSchedule = MobEventSchedule.createFromJSON(scheduleEntryJson);
                this.mobEventSchedules.add(mobEventSchedule);
            }
        }
        if (this.mobEventSchedules.size() > 0) {
            LycanitesMobs.logDebug("MobEvents", "Loaded " + this.mobEventSchedules.size() + " Mob Event Schedules.");
        }
    }

    @Override
    public void parseJson(ModInfo groupInfo, String name, JsonObject json) {
    }

    public void reload() {
        LycanitesMobs.logDebug("MobEvents", "Destroying JSON Mob Events!");
        for (MobEvent mobEvent : this.mobEvents.values().toArray(new MobEvent[this.mobEvents.size()])) {
            mobEvent.destroy();
        }
        this.loadAllFromJSON(LycanitesMobs.modInfo);
    }

    public void addMobEvent(MobEvent mobEvent) {
        if (mobEvent == null) {
            return;
        }
        this.mobEvents.put(mobEvent.name, mobEvent);
        try {
            AssetManager.addSound("mobevent_" + mobEvent.title.toLowerCase(), LycanitesMobs.modInfo, "mobevent." + mobEvent.title.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeMobEvent(MobEvent mobEvent) {
        if (!this.mobEvents.containsKey(mobEvent.name)) {
            LycanitesMobs.logWarning("", "[MobEvents] Tried to remove a Mob Event that hasn't been added: " + mobEvent.name);
            return;
        }
        this.mobEvents.remove(mobEvent.name);
    }

    public MobEvent getMobEvent(String mobEventName) {
        if (!this.mobEvents.containsKey(mobEventName)) {
            return null;
        }
        return this.mobEvents.get(mobEventName);
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        if (worldExt.lastEventUpdateTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastEventUpdateTime = world.func_82737_E();
        if (worldExt.serverWorldEventPlayer != null) {
            worldExt.serverWorldEventPlayer.onUpdate();
        }
        if (worldExt.serverMobEventPlayers.size() > 0) {
            for (MobEventPlayerServer mobEventPlayerServer : worldExt.serverMobEventPlayers.values().toArray(new MobEventPlayerServer[worldExt.serverMobEventPlayers.size()])) {
                mobEventPlayerServer.onUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (LycanitesMobs.proxy.getClientPlayer() == null) {
            return;
        }
        World world = LycanitesMobs.proxy.getClientPlayer().func_130014_f_();
        if (!world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        for (MobEventPlayerClient mobEventPlayerClient : worldExt.clientMobEventPlayers.values()) {
            mobEventPlayerClient.onUpdate();
        }
        if (worldExt.clientWorldEventPlayer != null) {
            worldExt.clientWorldEventPlayer.onUpdate();
        }
    }
}

