/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.IMusable;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrunkShell
extends Block {
    public static final PropertyEnum<CoordUtils.Surround> COREDIR = PropertyEnum.func_177709_a((String)"coredir", CoordUtils.Surround.class);
    public static final String name = "trunkshell";

    public BlockTrunkShell() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COREDIR, (Comparable)((Object)CoordUtils.Surround.S)));
        this.setRegistryName(name);
        this.func_149663_c(name);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COREDIR, (Comparable)((Object)CoordUtils.Surround.values()[meta & 7]));
    }

    public int func_176201_c(IBlockState state) {
        return ((CoordUtils.Surround)((Object)state.func_177229_b(COREDIR))).ordinal() & 7;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COREDIR});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.getMuseUnchecked((IBlockAccess)worldIn, state, pos) == null) {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, state, pos);
        if (muse != null) {
            return muse.state.func_177230_c().removedByPlayer(muse.state, world, muse.pos, player, willHarvest);
        }
        return false;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, blockState, pos);
        return muse != null ? muse.state.func_177230_c().func_176195_g(muse.state, world, muse.pos) : 0.0f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, state, pos);
        return muse != null ? muse.state.func_177230_c().getSoundType(muse.state, world, muse.pos, entity) : SoundType.field_185848_a;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, pos);
        return muse != null ? muse.state.func_177230_c().getExplosionResistance(world, muse.pos, exploder, explosion) : 0.0f;
    }

    public boolean func_176200_f(IBlockAccess access, BlockPos pos) {
        return this.getMuse(access, pos) == null;
    }

    public CoordUtils.Surround getMuseDir(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        return (CoordUtils.Surround)((Object)state.func_177229_b(COREDIR));
    }

    @Nullable
    public ShellMuse getMuseUnchecked(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        return this.getMuseUnchecked(access, access.func_180495_p(pos), pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(@Nonnull IBlockAccess access, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        CoordUtils.Surround museDir = this.getMuseDir(state, pos);
        BlockPos musePos = pos.func_177971_a(museDir.getOffset());
        IBlockState museState = access.func_180495_p(musePos);
        Block block = museState.func_177230_c();
        if (block instanceof IMusable && ((IMusable)block).isMusable()) {
            return new ShellMuse(museState, musePos, museDir);
        }
        return null;
    }

    @Nullable
    public ShellMuse getMuse(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        return this.getMuse(access, access.func_180495_p(pos), pos);
    }

    @Nullable
    public ShellMuse getMuse(@Nonnull IBlockAccess access, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        ShellMuse muse = this.getMuseUnchecked(access, state, pos);
        if (muse == null || muse.getRadius() <= 8) {
            this.scheduleForClearing(access, pos);
        }
        return muse;
    }

    public void scheduleForClearing(IBlockAccess access, BlockPos pos) {
        if (access instanceof World) {
            World world = (World)access;
            if (!world.field_72995_K) {
                world.func_180497_b(pos.func_185334_h(), (Block)this, 0, 3);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.getMuse((IBlockAccess)world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        ShellMuse muse = this.getMuse(access, state, pos);
        if (muse != null) {
            AxisAlignedBB aabb = muse.state.func_185900_c(access, muse.pos);
            return aabb.func_186670_a(new BlockPos(muse.dir.getOffset())).func_191500_a(field_185505_j);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        AxisAlignedBB aabb = super.func_180646_a(blockState, worldIn, pos);
        return aabb == field_185505_j ? field_185506_k : aabb;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (entityIn instanceof EntityFallingTree) {
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        ShellMuse muse = this.getMuseUnchecked((IBlockAccess)worldIn, state, pos);
        return muse.state.func_185900_c((IBlockAccess)worldIn, muse.pos).func_186670_a(muse.pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, state, pos);
        return muse != null ? muse.state.func_177230_c().getPickBlock(muse.state, target, world, muse.pos, player) : ItemStack.field_190927_a;
    }

    public boolean isAir(IBlockState state, IBlockAccess access, BlockPos pos) {
        return this.getMuse(access, state, pos) == null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, pos);
        if (muse != null) {
            muse.state.func_177230_c().onBlockExploded(world, muse.pos, explosion);
        }
    }

    protected CoordUtils.Surround findDetachedMuse(World world, BlockPos pos) {
        for (CoordUtils.Surround s : CoordUtils.Surround.values()) {
            IBlockState state = world.func_180495_p(pos.func_177971_a(s.getOffset()));
            if (!(state.func_177230_c() instanceof IMusable)) continue;
            return s;
        }
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        CoordUtils.Surround surr;
        IBlockState newState = world.func_180495_p(pos);
        if (newState.func_177230_c() == Blocks.field_150350_a && (surr = this.findDetachedMuse(world, pos)) != null) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a(COREDIR, (Comparable)((Object)surr)));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ShellMuse muse = this.getMuse((IBlockAccess)world, pos);
        if (muse != null) {
            return muse.state.func_177230_c().func_180639_a(world, muse.pos, muse.state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            ShellMuse muse = this.getMuseUnchecked((IBlockAccess)world, state, pos);
            if (muse == null) {
                return true;
            }
            IBlockState museState = muse.state;
            BlockPos musePos = muse.pos;
            manager.func_180533_a(musePos, museState);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos shellPos = target.func_178782_a();
        if (state.func_177230_c() == this) {
            ShellMuse muse = this.getMuseUnchecked((IBlockAccess)world, state, shellPos);
            if (muse == null) {
                return true;
            }
            IBlockState museState = muse.state;
            BlockPos musePos = muse.pos;
            Random rand = world.field_73012_v;
            int x = musePos.func_177958_n();
            int y = musePos.func_177956_o();
            int z = musePos.func_177952_p();
            AxisAlignedBB axisalignedbb = museState.func_185900_c((IBlockAccess)world, musePos);
            double d0 = (double)x + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
            double d1 = (double)y + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
            double d2 = (double)z + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
            switch (target.field_178784_b) {
                case DOWN: {
                    d1 = (double)y + axisalignedbb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    d1 = (double)y + axisalignedbb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    d2 = (double)z + axisalignedbb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    d2 = (double)z + axisalignedbb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    d0 = (double)x + axisalignedbb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    d0 = (double)x + axisalignedbb.field_72336_d + 0.1;
                }
            }
            ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)museState)});
            if (particle != null) {
                particle.func_174846_a(musePos).func_70543_e(0.2f).func_70541_f(0.6f);
            }
        }
        return true;
    }

    public static class ShellMuse {
        public final IBlockState state;
        public final BlockPos pos;
        public final CoordUtils.Surround dir;

        public ShellMuse(IBlockState state, BlockPos pos, CoordUtils.Surround dir) {
            this.state = state;
            this.pos = pos;
            this.dir = dir;
        }

        public int getRadius() {
            Block block = this.state.func_177230_c();
            return block instanceof BlockBranch ? ((BlockBranch)block).getRadius(this.state) : 0;
        }
    }
}

