/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class DTCommand
extends CommandBase {
    public static final String COMMAND = "dt";
    public static final String REPOP = "repop";
    public static final String SETTREE = "settree";
    public static final String DEFAULTJOCODE = "JP";

    public String func_71517_b() {
        return COMMAND;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.dynamictrees.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException("commands.dynamictrees.usage", new Object[0]);
        }
        if (args.length >= 1) {
            if (REPOP.equals(args[0])) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.dynamictrees.repop.run", new Object[0]));
                WorldGenRegistry.populateDataBase();
            } else if (SETTREE.equals(args[0])) {
                BlockPos pos = BlockPos.field_177992_a;
                Species species = null;
                String joCode = "";
                if (args.length < 5) {
                    throw new WrongUsageException("commands.dynamictrees.setree.usage", new Object[0]);
                }
                switch (args.length) {
                    case 6: {
                        joCode = args[5];
                    }
                    case 5: {
                        species = TreeRegistry.findSpeciesSloppy(args[4]);
                    }
                    case 4: {
                        pos = DTCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
                    }
                }
                if (species == Species.NULLSPECIES) {
                    throw new WrongUsageException("commands.dynamictrees.setree.specieserror", new Object[]{args[4]});
                }
                if (joCode.isEmpty()) {
                    joCode = DEFAULTJOCODE;
                }
                World world = sender.func_130014_f_();
                species.getJoCode(joCode).setCareful(true).generate(world, species, pos, world.func_180494_b(pos), EnumFacing.SOUTH, 8, SafeChunkBounds.ANY);
            } else {
                throw new WrongUsageException("commands.dynamictrees.usage", new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return DTCommand.func_71530_a((String[])args, (String[])new String[]{REPOP, SETTREE});
        }
        if (args.length >= 2 && SETTREE.equals(args[0])) {
            switch (args.length) {
                case 2: 
                case 3: 
                case 4: {
                    return DTCommand.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
                }
                case 5: {
                    return DTCommand.func_175762_a((String[])args, (Collection)Species.REGISTRY.getKeys());
                }
                case 6: {
                    return Lists.newArrayList((Object[])new String[]{DEFAULTJOCODE});
                }
            }
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }
}

