/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.animation;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationConstants;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerData;
import com.ferreusveritas.dynamictrees.entities.animation.IAnimationHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnimationHandlerFallover
implements IAnimationHandler {
    @Override
    public String getName() {
        return "fallover";
    }

    HandlerData getData(EntityFallingTree entity) {
        return entity.animationHandlerData instanceof HandlerData ? (HandlerData)entity.animationHandlerData : new HandlerData();
    }

    @Override
    public void initMotion(EntityFallingTree entity) {
        entity.animationHandlerData = new HandlerData();
        EntityFallingTree.standardDropLeavesPayLoad(entity);
        BlockPos belowBlock = entity.getDestroyData().cutPos.func_177977_b();
        if (entity.field_70170_p.func_180495_p(belowBlock).isSideSolid((IBlockAccess)entity.field_70170_p, belowBlock, EnumFacing.UP)) {
            entity.field_70122_E = true;
            return;
        }
    }

    @Override
    public void handleMotion(EntityFallingTree entity) {
        float fallSpeed = this.getData((EntityFallingTree)entity).fallSpeed;
        if (entity.field_70122_E) {
            float height = (float)entity.getMassCenter().field_72448_b * 2.0f;
            fallSpeed = (float)((double)fallSpeed + 0.2 / (double)height);
            this.addRotation(entity, fallSpeed);
        }
        entity.field_70181_x -= (double)0.03f;
        entity.field_70163_u += entity.field_70181_x;
        World world = entity.field_70170_p;
        int radius = 8;
        IExtendedBlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch((IBlockState)state)) {
            radius = ((BlockBranch)state.func_177230_c()).getRadius((IBlockState)state);
        }
        AxisAlignedBB fallBox = new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + 1.0, entity.field_70161_v + (double)radius);
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        IBlockState collState = world.func_180495_p(pos);
        AxisAlignedBB collBox = collState.func_185890_d((IBlockAccess)world, pos);
        if (collBox != null && fallBox.func_72326_a(collBox = collBox.func_186670_a(pos))) {
            entity.field_70181_x = 0.0;
            entity.field_70167_r = entity.field_70163_u = collBox.field_72337_e;
            entity.field_70122_E = true;
        }
        if (fallSpeed > 0.0f && this.testCollision(entity)) {
            this.addRotation(entity, -fallSpeed);
            ++this.getData((EntityFallingTree)entity).bounces;
            entity.landed = Math.abs(fallSpeed *= -0.25f) < 0.02f;
        }
        world = entity.field_70170_p;
        if (ModConfigs.enableFallingTreeDamage && !world.field_72995_K) {
            List<EntityLivingBase> elist = this.testEntityCollision(entity);
            for (EntityLivingBase living : elist) {
                if (this.getData((EntityFallingTree)entity).entitiesHit.contains(living)) continue;
                this.getData((EntityFallingTree)entity).entitiesHit.add(living);
                float damage = entity.getDestroyData().woodVolume * Math.abs(fallSpeed) * 3.0f;
                if (this.getData((EntityFallingTree)entity).bounces != 0 || !(damage > 2.0f)) continue;
                living.field_70159_w += (double)(world.field_73012_v.nextFloat() * (float)entity.getDestroyData().toolDir.func_176734_d().func_82601_c() * damage * 0.2f);
                living.field_70159_w += (double)world.field_73012_v.nextFloat() - 0.5;
                living.field_70181_x += (double)(world.field_73012_v.nextFloat() * fallSpeed * 0.25f);
                living.field_70179_y += (double)(world.field_73012_v.nextFloat() * (float)entity.getDestroyData().toolDir.func_176734_d().func_82599_e() * damage * 0.2f);
                living.field_70179_y += (double)world.field_73012_v.nextFloat() - 0.5;
                living.func_70097_a((DamageSource)AnimationConstants.TREE_DAMAGE, damage *= ModConfigs.fallingTreeDamageMultiplier);
            }
        }
        this.getData((EntityFallingTree)entity).fallSpeed = fallSpeed;
    }

    private boolean testCollision(EntityFallingTree entity) {
        EnumFacing toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.func_176740_k() == EnumFacing.Axis.X ? entity.field_70177_z : entity.field_70125_A;
        int offsetX = toolDir.func_82601_c();
        int offsetZ = toolDir.func_82599_e();
        float h = MathHelper.func_76126_a((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = MathHelper.func_76134_b((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.field_70165_t + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.field_70163_u - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.field_70161_v + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        trunkHeight = Math.min(trunkHeight, 24);
        for (int segment = 0; segment < trunkHeight; ++segment) {
            float segX = xbase + h * (float)segment * (float)offsetX;
            float segY = ybase + v * (float)segment;
            float segZ = zbase + h * (float)segment * (float)offsetZ;
            float tex = 0.0625f;
            float half = MathHelper.func_76131_a((float)(tex * (float)(segment + 1) * 2.0f), (float)tex, (float)maxRadius);
            AxisAlignedBB testBB = new AxisAlignedBB((double)(segX - half), (double)(segY - half), (double)(segZ - half), (double)(segX + half), (double)(segY + half), (double)(segZ + half));
            if (entity.field_70170_p.func_184144_a((Entity)entity, testBB).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void addRotation(EntityFallingTree entity, float delta) {
        EnumFacing toolDir = entity.getDestroyData().toolDir;
        switch (toolDir) {
            case NORTH: {
                entity.field_70125_A += delta;
                break;
            }
            case SOUTH: {
                entity.field_70125_A -= delta;
                break;
            }
            case WEST: {
                entity.field_70177_z += delta;
                break;
            }
            case EAST: {
                entity.field_70177_z -= delta;
                break;
            }
        }
        entity.field_70125_A = MathHelper.func_76142_g((float)entity.field_70125_A);
        entity.field_70177_z = MathHelper.func_76142_g((float)entity.field_70177_z);
    }

    public List<EntityLivingBase> testEntityCollision(EntityFallingTree entity) {
        World world = entity.field_70170_p;
        EnumFacing toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.func_176740_k() == EnumFacing.Axis.X ? entity.field_70177_z : entity.field_70125_A;
        int offsetX = toolDir.func_82601_c();
        int offsetZ = toolDir.func_82599_e();
        float h = MathHelper.func_76126_a((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = MathHelper.func_76134_b((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.field_70165_t + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.field_70163_u - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.field_70161_v + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float segX = xbase + h * (float)(trunkHeight - 1) * (float)offsetX;
        float segY = ybase + v * (float)(trunkHeight - 1);
        float segZ = zbase + h * (float)(trunkHeight - 1) * (float)offsetZ;
        final float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        final Vec3d vec3d1 = new Vec3d((double)xbase, (double)ybase, (double)zbase);
        final Vec3d vec3d2 = new Vec3d((double)segX, (double)segY, (double)segZ);
        return world.func_175674_a((Entity)entity, new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity apply) {
                if (apply instanceof EntityLivingBase && apply.func_70067_L()) {
                    AxisAlignedBB axisalignedbb = apply.func_174813_aQ().func_186662_g((double)maxRadius);
                    return axisalignedbb.func_72318_a(vec3d1) || axisalignedbb.func_72327_a(vec3d1, vec3d2) != null;
                }
                return false;
            }
        })).stream().map(a -> (EntityLivingBase)a).collect(Collectors.toList());
    }

    @Override
    public void dropPayload(EntityFallingTree entity) {
        World world = entity.field_70170_p;
        BlockPos cutPos = entity.getDestroyData().cutPos;
        entity.getPayload().forEach(i -> Block.func_180635_a((World)world, (BlockPos)cutPos, (ItemStack)i));
    }

    @Override
    public boolean shouldDie(EntityFallingTree entity) {
        boolean dead;
        boolean bl = dead = Math.abs(entity.field_70125_A) >= 160.0f || Math.abs(entity.field_70177_z) >= 160.0f || entity.landed || entity.field_70173_aa > 120 + entity.getDestroyData().trunkHeight;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTransform(EntityFallingTree entity, float entityYaw, float partialTicks) {
        float yaw = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70126_B, entity.field_70177_z, partialTicks));
        float pit = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70127_C, entity.field_70125_A, partialTicks));
        int radius = entity.getDestroyData().getBranchRadius(0);
        EnumFacing toolDir = entity.getDestroyData().toolDir;
        Vec3d toolVec = new Vec3d((double)toolDir.func_82601_c(), (double)toolDir.func_96559_d(), (double)toolDir.func_82599_e()).func_186678_a((double)((float)radius / 16.0f));
        GlStateManager.func_179137_b((double)(-toolVec.field_72450_a), (double)(-toolVec.field_72448_b), (double)(-toolVec.field_72449_c));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)pit, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)toolVec.field_72450_a, (double)toolVec.field_72448_b, (double)toolVec.field_72449_c);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender(EntityFallingTree entity) {
        return true;
    }

    class HandlerData
    extends AnimationHandlerData {
        float fallSpeed = 0.0f;
        int bounces = 0;
        HashSet<EntityLivingBase> entitiesHit = new HashSet();

        HandlerData() {
        }
    }
}

