/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.event.SeedVoluntaryPlantEvent;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Seed
extends Item {
    public static final Seed NULLSEED = new Seed("null"){
        {
            this.func_77637_a(null);
        }

        @Override
        public void setSpecies(Species species, ItemStack seedStack) {
        }

        @Override
        public Species getSpecies(ItemStack seedStack) {
            return Species.NULLSPECIES;
        }

        @Override
        public boolean onEntityItemUpdate(EntityItem entityItem) {
            entityItem.func_70106_y();
            return false;
        }

        @Override
        public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            return EnumActionResult.FAIL;
        }
    };
    private Species species;

    public Seed(String name) {
        this.setRegistryName(name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(ModTabs.dynamicTreesTab);
    }

    public void setSpecies(Species species, ItemStack seedStack) {
        this.species = species;
    }

    public Species getSpecies(ItemStack seedStack) {
        return this.species;
    }

    public boolean isValid() {
        return this != NULLSEED;
    }

    public void ifValid(Consumer<Seed> c) {
        if (this.isValid()) {
            c.accept(this);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.lifespan == 6000) {
            entityItem.lifespan = this.getTimeToLive(entityItem.func_92059_d()) + 20;
            if (entityItem.lifespan == 6000) {
                entityItem.lifespan = 6001;
            }
        }
        if (entityItem.field_70173_aa >= entityItem.lifespan - 20) {
            World world = entityItem.field_70170_p;
            if (!world.field_72995_K) {
                ItemStack seedStack = entityItem.func_92059_d();
                BlockPos pos = new BlockPos((Entity)entityItem);
                SeedVoluntaryPlantEvent seedVolEvent = new SeedVoluntaryPlantEvent(entityItem, this.getSpecies(seedStack), pos, this.shouldPlant(world, pos, seedStack));
                MinecraftForge.EVENT_BUS.post((Event)seedVolEvent);
                if (!seedVolEvent.isCanceled() && seedVolEvent.getWillPlant()) {
                    this.doPlanting(world, pos, null, seedStack);
                }
                seedStack.func_190920_e(0);
            }
            entityItem.func_70106_y();
        }
        return false;
    }

    public boolean doPlanting(World world, BlockPos pos, EntityPlayer planter, ItemStack seedStack) {
        Species species = this.getSpecies(seedStack);
        if (species.plantSapling(world, pos)) {
            String joCode = this.getCode(seedStack);
            if (!joCode.isEmpty()) {
                world.func_175698_g(pos);
                species.getJoCode(joCode).setCareful(true).generate(world, species, pos.func_177977_b(), world.func_180494_b(pos), planter != null ? planter.func_174811_aO() : EnumFacing.NORTH, 8, SafeChunkBounds.ANY);
            }
            return true;
        }
        return false;
    }

    public boolean shouldPlant(World world, BlockPos pos, ItemStack seedStack) {
        if (this.hasForcePlant(seedStack)) {
            return true;
        }
        if (!world.func_175710_j(pos)) {
            return false;
        }
        float plantChance = this.getSpecies(seedStack).biomeSuitability(world, pos) * ModConfigs.seedPlantRate;
        TreeGenerator treeGen = TreeGenerator.getTreeGenerator();
        if (ModConfigs.seedOnlyForest && treeGen != null) {
            plantChance *= treeGen.getBiomeDataBase(world).getForestness(world.func_180494_b(pos));
        }
        float accum = 1.0f;
        int count = seedStack.func_190916_E();
        while (count-- > 0) {
            accum *= 1.0f - plantChance;
        }
        plantChance = 1.0f - accum;
        return plantChance > world.field_73012_v.nextFloat();
    }

    public boolean hasForcePlant(ItemStack seedStack) {
        boolean forcePlant = false;
        if (seedStack.func_77942_o()) {
            NBTTagCompound nbtData = seedStack.func_77978_p();
            forcePlant = nbtData.func_74767_n("forceplant");
        }
        return forcePlant;
    }

    public int getTimeToLive(ItemStack seedStack) {
        NBTTagCompound nbtData;
        int lifespan = ModConfigs.seedTimeToLive;
        if (seedStack.func_77942_o() && (nbtData = seedStack.func_77978_p()).func_74764_b("lifespan")) {
            lifespan = nbtData.func_74762_e("lifespan");
        }
        return lifespan;
    }

    public String getCode(ItemStack seedStack) {
        String joCode = "";
        if (seedStack.func_77942_o()) {
            NBTTagCompound nbtData = seedStack.func_77978_p();
            joCode = nbtData.func_74779_i("code");
        }
        return joCode;
    }

    public EnumActionResult onItemUseFlowerPot(EntityPlayer player, World world, BlockPos pos, EnumHand hand, ItemStack seedStack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState emptyPotState = world.func_180495_p(pos);
        if (emptyPotState.func_177230_c() instanceof BlockFlowerPot && emptyPotState == emptyPotState.func_177230_c().func_176223_P()) {
            Species species = this.getSpecies(seedStack);
            BlockBonsaiPot bonzaiPot = species.getBonzaiPot();
            world.func_175656_a(pos, bonzaiPot.func_176223_P());
            if (bonzaiPot.setSpecies(world, species, pos) && bonzaiPot.setPotState(world, emptyPotState, pos)) {
                seedStack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUsePlantSeed(EntityPlayer player, World world, BlockPos pos, EnumHand hand, ItemStack seedStack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
            facing = EnumFacing.UP;
        }
        if (facing == EnumFacing.UP && player.func_175151_a(pos, facing, seedStack) && player.func_175151_a(pos.func_177984_a(), facing, seedStack) && this.doPlanting(world, pos.func_177984_a(), player, seedStack)) {
            seedStack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack seedStack = player.func_184586_b(hand);
        if (this.onItemUseFlowerPot(player, world, pos, hand, seedStack, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
            return EnumActionResult.SUCCESS;
        }
        if (this.onItemUsePlantSeed(player, world, pos, hand, seedStack, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (stack.func_77942_o()) {
            NBTTagCompound nbtData;
            String joCode = this.getCode(stack);
            if (!joCode.isEmpty()) {
                tooltip.add("Code: \u00a76" + joCode);
            }
            if (this.hasForcePlant(stack)) {
                tooltip.add("Force Planting: \u00a73Enabled");
            }
            if ((nbtData = stack.func_77978_p()).func_74764_b("lifespan")) {
                tooltip.add("Seed Life Span: \u00a73" + nbtData.func_74762_e("lifespan"));
            }
        }
    }
}

