/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenHugeMushroom;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenHugeMushrooms
implements IPostGenFeature {
    protected final FeatureGenHugeMushroom mushGen;
    protected int maxShrooms = 2;
    protected int maxAttempts = 4;

    public FeatureGenHugeMushrooms(FeatureGenHugeMushroom mushGen) {
        this.mushGen = mushGen;
    }

    public FeatureGenHugeMushrooms() {
        this(new FeatureGenHugeMushroom());
    }

    public FeatureGenHugeMushrooms setMaxShrooms(int max) {
        this.maxShrooms = max;
        return this;
    }

    public FeatureGenHugeMushrooms setMaxAttempts(int max) {
        this.maxAttempts = max;
        return this;
    }

    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        boolean worldGen;
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (endPoints.isEmpty() || !worldGen) {
            return false;
        }
        BlockPos lowest = Collections.min(endPoints, (a, b) -> a.func_177956_o() - b.func_177956_o());
        Random rand = world.field_73012_v;
        int success = 0;
        if (radius >= 5) {
            for (int tries = 0; tries < this.maxAttempts; ++tries) {
                int height;
                int maxHeight;
                float angle = (float)((double)rand.nextFloat() * Math.PI * 2.0);
                int xOff = (int)(MathHelper.func_76126_a((float)angle) * (float)(radius - 1));
                int zOff = (int)(MathHelper.func_76134_b((float)angle) * (float)(radius - 1));
                BlockPos mushPos = rootPos.func_177982_a(xOff, 0, zOff);
                if (!safeBounds.inBounds(mushPos = CoordUtils.findGround(world, new BlockPos((Vec3i)mushPos)).func_177984_a(), true) || (maxHeight = lowest.func_177956_o() - mushPos.func_177956_o()) < 2 || !this.mushGen.setHeight(height = MathHelper.func_76125_a((int)(rand.nextInt(maxHeight) + 3), (int)3, (int)maxHeight)).generate(world, mushPos.func_177977_b(), species, biome, rand, radius, safeBounds) || ++success < this.maxShrooms) continue;
                return true;
            }
        }
        return false;
    }
}

