/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenVine
implements IPostGenFeature {
    protected final PropertyBool[] vineMap = new PropertyBool[]{null, null, BlockVine.field_176273_b, BlockVine.field_176279_N, BlockVine.field_176280_O, BlockVine.field_176278_M};
    protected int qty = 4;
    protected int maxLength = 8;
    protected float verSpread = 60.0f;
    protected float rayDistance = 5.0f;
    protected Block vineBlock = Blocks.field_150395_bd;

    public FeatureGenVine setQuantity(int qty) {
        this.qty = qty;
        return this;
    }

    public FeatureGenVine setMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    public FeatureGenVine setVerSpread(float verSpread) {
        this.verSpread = verSpread;
        return this;
    }

    public FeatureGenVine setRayDistance(float rayDistance) {
        this.rayDistance = rayDistance;
        return this;
    }

    public FeatureGenVine setVineBlock(Block vineBlock) {
        this.vineBlock = vineBlock;
        return this;
    }

    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (safeBounds != SafeChunkBounds.ANY && !endPoints.isEmpty()) {
            for (int i = 0; i < this.qty; ++i) {
                BlockPos endPoint = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                this.addVine(world, species, rootPos, endPoint, safeBounds);
            }
            return true;
        }
        return false;
    }

    protected void addVine(World world, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        PropertyBool vineSide;
        BlockPos vinePos;
        RayTraceResult result = CoordUtils.branchRayTrace(world, species, rootPos, branchPos, 90.0f, this.verSpread, this.rayDistance, safeBounds);
        if (result != null && (vinePos = result.func_178782_a().func_177972_a(result.field_178784_b)) != BlockPos.field_177992_a && safeBounds.inBounds(vinePos, true) && (vineSide = this.vineMap[result.field_178784_b.func_176734_d().func_176745_a()]) != null) {
            IBlockState vineState = this.vineBlock.func_176223_P().func_177226_a((IProperty)vineSide, (Comparable)Boolean.valueOf(true));
            int len = MathHelper.func_76125_a((int)(world.field_73012_v.nextInt(this.maxLength) + 3), (int)3, (int)this.maxLength);
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos);
            for (int i = 0; i < len && world.func_175623_d((BlockPos)mPos); ++i) {
                world.func_175656_a((BlockPos)mPos, vineState);
                mPos.func_185336_p(mPos.func_177956_o() - 1);
            }
        }
    }
}

