/*
 * Decompiled with CFR 0.152.
 */
package tschipp.forgottenitems.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import tschipp.forgottenitems.FIM;
import tschipp.forgottenitems.items.ItemList;
import tschipp.forgottenitems.network.ForbiddenPacket;
import tschipp.forgottenitems.network.SeedPacket;
import tschipp.forgottenitems.util.FIConfig;
import tschipp.forgottenitems.util.FIHelper;
import tschipp.forgottenitems.util.FIWorldSavedData;

public class FIEvents {
    public static Map<String, List<ItemStack>> playerandtools = new HashMap<String, List<ItemStack>>();

    @SubscribeEvent
    public void onHarvestDrop(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getHarvester();
        IBlockState state = event.getState();
        List drops = event.getDrops();
        NonNullList logs = OreDictionary.getOres((String)"logWood");
        Block block = state.func_177230_c();
        if (player != null && !player.func_184614_ca().func_190926_b()) {
            if (player.func_184614_ca().func_77973_b() == ItemList.gamblePickaxe) {
                ItemStack harveststack = player.func_184614_ca();
                int fortunelevel = event.getFortuneLevel();
                Random rand = new Random();
                if (rand.nextFloat() < FIConfig.gamblePickaxeChance + (float)fortunelevel * FIConfig.gamblePickaxeFortuneChance) {
                    ItemStack drop = (ItemStack)drops.get(0);
                    drop.func_190917_f(drop.func_190916_E());
                    drops.set(0, drop);
                } else {
                    drops.clear();
                }
            } else if (Loader.isModLoaded((String)"barkifier") && player.func_184614_ca().func_77973_b() == ItemList.barkifiedAxe) {
                ItemStack heldItem = player.func_184614_ca();
                if (state.func_177228_b().containsKey((Object)BlockLog.field_176299_a)) {
                    int meta = block.func_176201_c(state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
                    ItemStack stack = new ItemStack(Item.func_111206_d((String)"barkifier:barkified_log"), 1);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("block", block.getRegistryName().toString());
                    tag.func_74768_a("meta", meta);
                    stack.func_77982_d(tag);
                    drops.clear();
                    drops.add(stack);
                } else {
                    for (int i = 0; i < logs.size(); ++i) {
                        if (((ItemStack)logs.get(i)).func_77973_b() != Item.func_150898_a((Block)state.func_177230_c())) continue;
                        int meta = block.func_176201_c(state);
                        if (meta <= 3) {
                            meta += 12;
                        } else if (meta >= 4 && meta <= 7) {
                            meta += 8;
                        } else if (meta >= 8 && meta <= 11) {
                            meta += 4;
                        }
                        ItemStack stack = new ItemStack(Item.func_111206_d((String)"barkifier:barkified_log"), 1);
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74778_a("block", block.getRegistryName().toString());
                        tag.func_74768_a("meta", meta);
                        stack.func_77982_d(tag);
                        drops.clear();
                        drops.add(stack);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IBlockState block;
        EntityLivingBase living = event.getEntityLiving();
        if (!(!(living instanceof EntityPlayer) || living instanceof FakePlayer || (block = player.field_70170_p.func_180495_p((player = (EntityPlayer)living).func_180425_c())).func_185904_a() != Material.field_151586_h && block.func_185904_a() != Material.field_151587_i || player.func_184812_l_())) {
            if (FIHelper.hasArmorItem(ItemList.golemHelmet, player)) {
                player.func_70024_g(0.0, -0.01, 0.0);
            }
            if (FIHelper.hasArmorItem(ItemList.golemChestplate, player)) {
                player.func_70024_g(0.0, -0.01, 0.0);
            }
            if (FIHelper.hasArmorItem(ItemList.golemLeggings, player)) {
                player.func_70024_g(0.0, -0.01, 0.0);
            }
            if (FIHelper.hasArmorItem(ItemList.golemBoots, player)) {
                player.func_70024_g(0.0, -0.01, 0.0);
            }
            if (FIHelper.hasArmorItem(ItemList.lifebelt, player)) {
                player.func_70024_g(0.0, 0.05, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer) {
            int slot;
            EntityPlayer player = (EntityPlayer)living;
            ArrayList<ItemStack> boundTools = new ArrayList<ItemStack>();
            String playername = player.func_146103_bH().getName();
            while (FIHelper.hasItem(ItemList.boundPickaxe, player)) {
                slot = FIHelper.getSlotForItem(ItemList.boundPickaxe, player);
                ItemStack pick = player.field_71071_by.func_70301_a(slot);
                boundTools.add(pick);
                player.field_71071_by.func_70304_b(slot);
            }
            while (FIHelper.hasItem(ItemList.boundAxe, player)) {
                slot = FIHelper.getSlotForItem(ItemList.boundAxe, player);
                ItemStack axe = player.field_71071_by.func_70301_a(slot);
                boundTools.add(axe);
                player.field_71071_by.func_70304_b(slot);
            }
            while (FIHelper.hasItem(ItemList.boundShovel, player)) {
                slot = FIHelper.getSlotForItem(ItemList.boundShovel, player);
                ItemStack shovel = player.field_71071_by.func_70301_a(slot);
                boundTools.add(shovel);
                player.field_71071_by.func_70304_b(slot);
            }
            playerandtools.put(playername, boundTools);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        String playername;
        List<ItemStack> tools;
        EntityPlayer newPlayer = event.getEntityPlayer();
        EntityPlayer oldPlayer = event.getOriginal();
        if (event.isWasDeath() && !(newPlayer instanceof FakePlayer) && (tools = playerandtools.get(playername = newPlayer.func_146103_bH().getName())) != null) {
            for (int i = 0; i < tools.size(); ++i) {
                newPlayer.field_71071_by.func_70441_a(tools.get(i));
            }
            playerandtools.remove(playername);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        EntityLivingBase entity = event.getEntityLiving();
        Random rand = new Random();
        if (entity instanceof EntityPlayer) {
            ItemStack stack;
            int slot;
            EntityPlayer player = (EntityPlayer)entity;
            float amount = event.getAmount();
            if (FIHelper.hasItem(ItemList.shockTalisman, player) && (source == DamageSource.field_76379_h || source == DamageSource.field_188406_j)) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_71075_bZ.field_75102_a = true;
                    if (FIHelper.hasArmorItem(ItemList.cushionedBoots, player)) {
                        player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, amount * FIConfig.shockTalismanExplosionMultiplier * 0.25f, true);
                    } else {
                        player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, amount * FIConfig.shockTalismanExplosionMultiplier, true);
                    }
                    player.field_71075_bZ.field_75102_a = false;
                    slot = FIHelper.getSlotForItem(ItemList.shockTalisman, player);
                    stack = player.field_71071_by.func_70301_a(slot);
                    stack.func_77972_a((int)amount, (EntityLivingBase)player);
                    player.field_71071_by.func_70299_a(slot, stack);
                }
                event.setCanceled(true);
            }
            if (FIHelper.hasArmorItem(ItemList.cushionedBoots, player) && (source == DamageSource.field_76379_h || source == DamageSource.field_188406_j)) {
                event.setAmount(amount * 0.25f);
                if ((double)rand.nextFloat() > 0.35) {
                    slot = FIHelper.getSlotForItem(ItemList.cushionedBoots, player);
                    stack = player.field_71071_by.func_70301_a(slot);
                    stack.func_77972_a((int)(amount * rand.nextFloat()), (EntityLivingBase)player);
                    player.field_71071_by.func_70299_a(slot, stack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickupItem(EntityItemPickupEvent event) {
        String playername;
        String owner;
        EntityItem item = event.getItem();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = item.func_92059_d();
        if (!stack.func_190926_b() && player != null && stack.func_77973_b() == ItemList.boundPickaxe && stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && !(owner = stack.func_77978_p().func_74779_i("owner")).equals(playername = player.func_146103_bH().getName())) {
            event.setCanceled(true);
        }
        if (!stack.func_190926_b() && player != null && stack.func_77973_b() == ItemList.boundAxe && stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && !(owner = stack.func_77978_p().func_74779_i("owner")).equals(playername = player.func_146103_bH().getName())) {
            event.setCanceled(true);
        }
        if (!stack.func_190926_b() && player != null && stack.func_77973_b() == ItemList.boundShovel && stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && !(owner = stack.func_77978_p().func_74779_i("owner")).equals(playername = player.func_146103_bH().getName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        String name = event.getName().toString();
        ArrayList<HashMap<Item, Item>> custom = FIHelper.CUSTOM_OUTPUTS_CORES;
        int customRecipeAmount = 0;
        for (int k = 0; k < custom.size(); ++k) {
            if (custom.get(k) == null) continue;
            ++customRecipeAmount;
        }
        if (name.equals("minecraft:chests/igloo_chest") || name.equals("minecraft:chests/end_city_treasure") || name.equals("minecraft:chests/stronghold_library") || name.equals("minecraft:chests/woodland_mansion") || name.equals("minecraft:chests/jungle_temple") || name.equals("minecraft:chests/desert_pyramid")) {
            LootEntryItem loot;
            NBTTagCompound tag;
            LootEntry[] runes = new LootEntry[25 + customRecipeAmount + 1];
            for (int i = 1; i <= 25; ++i) {
                if (i == 24 && Loader.isModLoaded((String)"barkifier")) {
                    tag = new NBTTagCompound();
                    tag.func_74768_a("id", 23);
                    loot = new LootEntryItem(ItemList.craftingRune, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], tag)}, new LootCondition[0], "crafting_rune_" + i);
                    runes[i - 1] = loot;
                    continue;
                }
                tag = new NBTTagCompound();
                tag.func_74768_a("id", i);
                loot = new LootEntryItem(ItemList.craftingRune, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], tag)}, new LootCondition[0], "crafting_rune_" + i);
                runes[i - 1] = loot;
            }
            for (int k = 0; k < custom.size(); ++k) {
                if ((k & 1) != 1 || custom.get(k) == null) continue;
                tag = new NBTTagCompound();
                tag.func_74768_a("id", k);
                loot = new LootEntryItem(ItemList.craftingRune, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], tag), new SetMetadata(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "crafting_rune_custom_" + k);
                runes[25 + k / 2] = loot;
            }
            LootEntryItem air = new LootEntryItem(ItemStack.field_190927_a.func_77973_b(), (25 + customRecipeAmount) * 2, 0, new LootFunction[0], new LootCondition[0], "air");
            runes[runes.length - 1] = air;
            table.addPool(new LootPool(runes, new LootCondition[0], new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 0.0f), "crafting_runes"));
            event.setTable(table);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            long seed = Math.abs(world.func_72905_C());
            FIWorldSavedData.getInstance(world).setSeed(seed);
            FIWorldSavedData.getInstance(world).setForbidden(FIHelper.getForbiddenList());
            FIM.network.sendToAll((IMessage)new SeedPacket(String.valueOf(seed)));
            FIM.network.sendToAll((IMessage)new ForbiddenPacket(FIHelper.getForbiddenList().toString()));
            FIWorldSavedData.getInstance(world).func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        World world = event.player.field_70170_p;
        if (!world.field_72995_K) {
            long seed = Math.abs(world.func_72905_C());
            FIWorldSavedData.getInstance(world).setSeed(seed);
            FIWorldSavedData.getInstance(world).setForbidden(FIHelper.getForbiddenList());
            FIM.network.sendToAll((IMessage)new SeedPacket(String.valueOf(seed)));
            FIM.network.sendToAll((IMessage)new ForbiddenPacket(FIHelper.getForbiddenList().toString()));
            FIWorldSavedData.getInstance(world).func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        World world = event.player.field_70170_p;
        if (!world.field_72995_K) {
            long seed = Math.abs(world.func_72905_C());
            FIWorldSavedData.getInstance(world).setSeed(seed);
            FIWorldSavedData.getInstance(world).setForbidden(FIHelper.getForbiddenList());
            FIM.network.sendToAll((IMessage)new SeedPacket(String.valueOf(seed)));
            FIM.network.sendToAll((IMessage)new ForbiddenPacket(FIHelper.getForbiddenList().toString()));
            FIWorldSavedData.getInstance(world).func_76185_a();
        }
    }
}

