/*
 * Decompiled with CFR 0.152.
 */
package tschipp.forgottenitems.util;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class FIWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "forgottenitems".toUpperCase() + "_DATA";
    private long seed;
    private ArrayList<String> forbiddenList;

    public FIWorldSavedData() {
        super(DATA_NAME);
    }

    public FIWorldSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.seed = tag.func_74763_f("seed");
        this.forbiddenList = new ArrayList<String>(Arrays.asList(tag.func_74779_i("forbidden").split(", ")));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74772_a("seed", this.seed);
        tag.func_74778_a("forbidden", this.forbiddenList.toString().replace("]", "").replace("[", ""));
        return tag;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setForbidden(ArrayList<String> forbiddenList) {
        this.forbiddenList = forbiddenList;
    }

    public ArrayList<String> getForbidden() {
        return this.forbiddenList;
    }

    public static FIWorldSavedData getInstance(World world) {
        MapStorage storage = world.getPerWorldStorage();
        FIWorldSavedData instance = (FIWorldSavedData)storage.func_75742_a(FIWorldSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new FIWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

