/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol;

import javax.annotation.Nonnull;
import ladysnake.spawnercontrol.config.CustomSpawnersConfig;
import ladysnake.spawnercontrol.config.MSCConfig;
import ladysnake.spawnercontrol.config.SpawnerConfigHolder;
import ladysnake.spawnercontrol.controlledspawner.CapabilityControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.IControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.TileEntityControlledSpawner;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="spawnercontrol", name="Mob Spawner Control", version="1.6.3b", acceptedMinecraftVersions="[1.12, 1.13)", guiFactory="ladysnake.spawnercontrol.client.MSCConfigFactory", dependencies="required-after:forge@[14.23.2.2596,);", acceptableRemoteVersions="*")
public class SpawnerControl {
    public static final String MOD_ID = "spawnercontrol";
    static final String MOD_NAME = "Mob Spawner Control";
    static final String VERSION = "1.6.3b";
    static final String ACCEPTED_VERSIONS = "[1.12, 1.13)";
    public static Logger LOGGER;
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        CustomSpawnersConfig.configDir = event.getModConfigurationDirectory();
        MSCConfig.portConfig();
        CustomSpawnersConfig.initCustomConfig();
        CapabilityManager.INSTANCE.register(IControllableSpawner.class, (Capability.IStorage)new CapabilityControllableSpawner.Storage(), CapabilityControllableSpawner.DefaultControllableSpawner::new);
        if (MSCConfig.customSpawners.length > 0) {
            GameRegistry.registerTileEntity(TileEntityControlledSpawner.class, (String)"spawnercontrol:controlled_spawner");
        }
        if (MSCConfig.makeCreativeTab) {
            creativeTab = new CreativeTabs(MOD_ID){

                @Nonnull
                public ItemStack func_78016_d() {
                    return new ItemStack(Blocks.field_150474_ac);
                }
            };
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistryHandler {
        @SubscribeEvent
        public static void onBlockRegister(RegistryEvent.Register<Block> event) {
            CustomSpawnersConfig.getCustomSpawnerConfigs().stream().map(SpawnerConfigHolder::createBlock).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> event) {
            CustomSpawnersConfig.getCustomSpawnerConfigs().stream().map(SpawnerConfigHolder::createItem).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerRenders(ModelRegistryEvent event) {
            ModelResourceLocation mrl = new ModelResourceLocation("mob_spawner", "inventory");
            for (SpawnerConfigHolder spawnerConfigHolder : CustomSpawnersConfig.getCustomSpawnerConfigs()) {
                ModelLoader.setCustomModelResourceLocation((Item)spawnerConfigHolder.getItem(), (int)0, (ModelResourceLocation)mrl);
                RegistryHandler.mapToSpawnerModel(spawnerConfigHolder.getBlock(), mrl);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private static void mapToSpawnerModel(Block block, final ModelResourceLocation mrl) {
            StateMapperBase ignoreState = new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nonnull IBlockState iBlockState) {
                    return mrl;
                }
            };
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)ignoreState);
        }
    }
}

