/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.nodeeditor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.gobbob.mobends.animatedentity.alterentry.AlterEntry;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.GuiHelper;
import net.gobbob.mobends.client.gui.elements.GuiAddButton;
import net.gobbob.mobends.client.gui.elements.GuiDropDownList;
import net.gobbob.mobends.client.gui.elements.GuiHelpButton;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationSection;
import net.gobbob.mobends.client.gui.nodeeditor.GuiParameterEditor;
import net.gobbob.mobends.network.NetworkConfiguration;
import net.gobbob.mobends.pack.BendsCondition;
import net.gobbob.mobends.pack.BendsPack;
import net.gobbob.mobends.pack.BendsTarget;
import net.gobbob.mobends.pack.PackManager;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNodeEditor {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mobends", "textures/gui/node_editor.png");
    public static final int EDITOR_WIDTH = 210;
    public static final int EDITOR_HEIGHT = 122;
    public static final int SCROLLBAR_WIDTH = 5;
    private int x = 0;
    private int y = 0;
    private int height = 0;
    private FontRenderer fontRenderer;
    private List<GuiAnimationSection> sections = new ArrayList<GuiAnimationSection>();
    private GuiAddButton buttonAddSection = new GuiAddButton();
    private GuiHelpButton helpButton = new GuiHelpButton();
    private GuiParameterEditor parameterEditor = new GuiParameterEditor(this);
    private GuiBendsMenu mainMenu;
    private GuiDropDownList targetList;
    private boolean unappliedChanges;
    private String[] alterableParts;
    private float scrollAmountX;
    private float scrollAmountY;
    private int scrollMaxX;
    private int scrollMaxY;
    private boolean editorHovered = false;

    public GuiNodeEditor(GuiBendsMenu mainMenu) {
        this.mainMenu = mainMenu;
        this.unappliedChanges = false;
        this.scrollAmountX = 0.0f;
        this.scrollAmountY = 0.0f;
        this.scrollMaxX = 0;
        this.scrollMaxY = 0;
        this.targetList = new GuiDropDownList(this).forbidNoValue();
        for (AlterEntry alterEntry : mainMenu.alterEntries) {
            this.targetList.addEntry(alterEntry.getDisplayName());
        }
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void initGui(int x, int y, int pX, int pY) {
        this.x = x;
        this.y = y;
        this.buttonAddSection.initGui(x + 3, y + 3 + this.height);
        this.helpButton.initGui(x + 196, y - 77);
        this.parameterEditor.initGui(pX, pY);
        this.targetList.setPosition(x + 56, y - 77);
        this.updateHeight();
    }

    public void display(int mouseX, int mouseY, float partialTicks) {
        this.editorHovered = mouseX >= this.x + 3 && mouseX <= this.x + 3 + 210 && mouseY >= this.y + 3 && mouseY <= this.y + 3 + 122;
        this.targetList.display();
        if (!PackManager.isCurrentPackLocal()) {
            return;
        }
        int[] position = GuiHelper.getDeScaledCoords(this.x + 3, this.y + 3 + 122);
        int[] size = GuiHelper.getDeScaledVector(210, 122);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)position[0], (int)position[1], (int)size[0], (int)size[1]);
        GL11.glTranslatef((float)(-this.scrollAmountX), (float)(-this.scrollAmountY), (float)0.0f);
        int yOffset = this.y + 3;
        for (int i = 0; i < this.sections.size(); ++i) {
            yOffset = this.sections.get(i).display(this.x + 3, yOffset, mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY);
        }
        this.buttonAddSection.display();
        GL11.glTranslatef((float)this.scrollAmountX, (float)this.scrollAmountY, (float)0.0f);
        GL11.glDisable((int)3089);
        this.parameterEditor.display(mouseX, mouseY, partialTicks);
        this.helpButton.display();
        if (this.scrollMaxY > 122) {
            int scrollBarHeight = 14884 / this.scrollMaxY;
            Draw.rectangle(this.x + 210 - 5 + 3, this.y + 3, 5, 122, -13421773);
            Draw.rectangle(this.x + 210 - 5 + 4, this.y + 4 + (int)(this.scrollAmountY * (float)(122 - scrollBarHeight) / (float)(this.scrollMaxY - 122)), 3, scrollBarHeight - 2, -10066330);
        }
        if (!NetworkConfiguration.isModelScalingAllowed()) {
            String errorText = I18n.func_135052_a((String)"mobends.gui.noscaleallowed", (Object[])new Object[0]);
            this.fontRenderer.func_175063_a(errorText, (float)(this.x + (210 - this.fontRenderer.func_78256_a(errorText)) / 2), (float)(this.y + 122 + 16), 0xFFDD33);
        }
    }

    public void populate(AlterEntry alterEntry) {
        BendsTarget target = BendsPack.getTarget(alterEntry.getName());
        this.sections = new ArrayList<GuiAnimationSection>();
        final GuiNodeEditor editor = this;
        if (target != null) {
            target.conditions.forEach(new BiConsumer(){

                public void accept(Object animationName, Object arg1) {
                    GuiAnimationSection section = new GuiAnimationSection(editor, (String)animationName);
                    section.populate((BendsCondition)arg1);
                    editor.addSection(section);
                }
            });
        }
        this.parameterEditor.deselect();
        this.alterableParts = alterEntry.getOwner().getAlterableParts();
        this.updateHeight();
        this.unappliedChanges = false;
        this.targetList.selectValue(this.mainMenu.currentAlterEntry);
    }

    public void addSection(GuiAnimationSection section) {
        this.sections.add(section);
    }

    public void addDefaultSection() {
        GuiAnimationSection section = new GuiAnimationSection(this, "");
        this.sections.add(section);
    }

    public void removeSection(GuiAnimationSection guiAnimationSection) {
        this.sections.remove(guiAnimationSection);
        this.onChange();
    }

    public void update(int mouseX, int mouseY) {
        this.editorHovered = mouseX >= this.x + 3 && mouseX <= this.x + 3 + 210 && mouseY >= this.y + 3 && mouseY <= this.y + 3 + 122;
        this.parameterEditor.update(mouseX, mouseY);
        this.targetList.update(mouseX, mouseY);
        this.helpButton.update(mouseX, mouseY);
        if (!this.editorHovered) {
            return;
        }
        this.buttonAddSection.update(mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY);
        int yOffset = 0;
        for (int i = 0; i < this.sections.size(); ++i) {
            this.sections.get(i).update(this.x, this.y + yOffset, mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY);
            yOffset += this.sections.get(i).getHeight();
        }
    }

    public void updateHeight() {
        this.height = 0;
        for (int i = 0; i < this.sections.size(); ++i) {
            this.height += this.sections.get(i).updateHeight(this.x + 3, this.y + 3 + this.height);
        }
        this.buttonAddSection.setPosition(this.x + 3, this.y + 3 + this.height);
        this.updateScrollBounds();
    }

    public void mouseClicked(int mouseX, int mouseY, int state) {
        if (state != 0) {
            return;
        }
        boolean lastUnappliedChanged = this.unappliedChanges;
        boolean pressed = false;
        if (this.targetList.mouseClicked(mouseX, mouseY, state)) {
            this.applyTargetListChanges(lastUnappliedChanged);
            pressed = true;
        }
        if (!PackManager.isCurrentPackLocal()) {
            return;
        }
        if (!pressed && this.parameterEditor.mouseClicked(mouseX, mouseY, state)) {
            pressed = true;
        } else if (this.editorHovered) {
            if (this.buttonAddSection.mouseClicked(mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY, state)) {
                this.addDefaultSection();
                this.updateHeight();
                this.onChange();
                pressed = true;
            }
            for (int i = 0; i < this.sections.size(); ++i) {
                if (!this.sections.get(i).mouseClicked(mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY, state)) continue;
                pressed = true;
            }
        }
        if (this.helpButton.mouseClicked(mouseX, mouseY, state)) {
            this.mainMenu.popUpHelp();
        }
        if (!pressed) {
            this.parameterEditor.deselect();
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int event) {
        this.buttonAddSection.mouseReleased(mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY, event);
        for (int i = 0; i < this.sections.size(); ++i) {
            this.sections.get(i).mouseReleased(mouseX + (int)this.scrollAmountX, mouseY + (int)this.scrollAmountY, event);
        }
        this.parameterEditor.mouseReleased(mouseX, mouseY, event);
    }

    public void handleMouseInput() {
        int i2;
        if (this.targetList.handleMouseInput()) {
            this.applyTargetListChanges(this.unappliedChanges);
            return;
        }
        if (!this.parameterEditor.handleMouseInput() && this.editorHovered && (i2 = Mouse.getEventDWheel()) != 0) {
            if (i2 > 0) {
                i2 = -1;
            } else if (i2 < 0) {
                i2 = 1;
            }
            this.scrollY(i2 * 15);
        }
        if (Mouse.isButtonDown((int)1) || Mouse.isButtonDown((int)2)) {
            this.scrollX(-Mouse.getDX());
            this.scrollY(Mouse.getDY());
        }
    }

    public void applyTargetListChanges(boolean unappliedChanged) {
        if (this.targetList.areChangedUnhandled()) {
            if (unappliedChanged) {
                this.mainMenu.popUpDiscardChanges(0);
            } else {
                this.mainMenu.selectAlterEntry((Integer)this.targetList.getSelectedValue());
            }
            this.targetList.setChangesHandled();
        }
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (!PackManager.isCurrentPackLocal()) {
            return;
        }
        this.parameterEditor.keyTyped(typedChar, keyCode);
    }

    public void applyChanges(BendsTarget target) {
        target.conditions.clear();
        for (int i = 0; i < this.sections.size(); ++i) {
            this.sections.get(i).applyChanges(target);
        }
        this.unappliedChanges = false;
    }

    public void onChange() {
        this.unappliedChanges = true;
        this.mainMenu.onNodeEditorChange();
        this.updateScrollBounds();
    }

    public void updateScrollBounds() {
        this.scrollMaxX = 0;
        this.scrollMaxY = 20;
        for (int i = 0; i < this.sections.size(); ++i) {
            if (this.sections.get(i).getGlobalWidth() > this.scrollMaxX) {
                this.scrollMaxX = this.sections.get(i).getGlobalWidth();
            }
            this.scrollMaxY += this.sections.get(i).getHeight();
        }
    }

    public void scrollX(float value) {
        int width = Math.max(0, this.scrollMaxX - 210);
        this.scrollAmountX = GUtil.clamp(this.scrollAmountX + value, 0.0f, width);
    }

    public void scrollY(float value) {
        int height = Math.max(0, this.scrollMaxY - 122);
        this.scrollAmountY = GUtil.clamp(this.scrollAmountY + value, 0.0f, height);
    }

    public GuiParameterEditor getParameterEditor() {
        return this.parameterEditor;
    }

    public boolean areChangesUnapplied() {
        return this.unappliedChanges;
    }

    public String[] getAlterableParts() {
        return this.alterableParts;
    }

    public GuiDropDownList getTargetList() {
        return this.targetList;
    }
}

