/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.pack.variable;

import java.util.HashMap;
import net.gobbob.mobends.data.EntityData;

public abstract class BendsVariable {
    public static EntityData tempData;
    public static HashMap variables;
    private String displayName;

    public static void init() {
        variables = new HashMap();
        BendsVariable.registerVariable("ticks", "Ticks", new Ticks());
        BendsVariable.registerVariable("ticksAfterPunch", "Ticks after punch", new TicksAfterPunch());
        BendsVariable.registerVariable("health", "Health", new Health());
        BendsVariable.registerVariable("random", "Random", new Random());
    }

    public static void registerVariable(String name, String displayName, BendsVariable variable) {
        variable.setDisplayName(displayName);
        variables.put(name, variable);
    }

    public static float getGlobalVar(String name) {
        if (tempData == null) {
            return 0.0f;
        }
        if (variables.containsKey(name)) {
            return ((BendsVariable)variables.get(name)).getValue();
        }
        return Float.POSITIVE_INFINITY;
    }

    public abstract float getValue();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private static class Random
    extends BendsVariable {
        private Random() {
        }

        @Override
        public float getValue() {
            return (float)Math.random();
        }
    }

    private static class Health
    extends BendsVariable {
        private Health() {
        }

        @Override
        public float getValue() {
            return tempData.getEntity().func_110143_aJ();
        }
    }

    private static class TicksAfterPunch
    extends BendsVariable {
        private TicksAfterPunch() {
        }

        @Override
        public float getValue() {
            return TicksAfterPunch.tempData.ticksAfterPunch;
        }
    }

    private static class Ticks
    extends BendsVariable {
        private Ticks() {
        }

        @Override
        public float getValue() {
            return Ticks.tempData.ticks;
        }
    }
}

