/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.api;

import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public interface IBackpack {
    @CapabilityInject(value=IBackpack.class)
    public static final Capability<IBackpack> CAPABILITY = null;

    public ItemStack getStack();

    public void setStack(ItemStack var1);

    public IBackpackData getData();

    public void setData(IBackpackData var1);

    public int getPlayersUsing();

    public void setPlayersUsing(int var1);

    public int getLidTicks();

    public int getPrevLidTicks();

    public void setLidTicks(int var1);

    default public IBackpackType getType() {
        return BackpackHelper.getBackpackType(this.getStack());
    }

    public static class Impl
    implements IBackpack {
        protected ItemStack stack = ItemStack.field_190927_a;
        protected IBackpackData data = null;
        protected int playersUsing = 0;
        protected int lidTicks = 0;
        protected int prevLidTicks = 0;

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void setStack(ItemStack value) {
            this.stack = value;
        }

        @Override
        public IBackpackData getData() {
            return this.data;
        }

        @Override
        public void setData(IBackpackData value) {
            this.data = value;
        }

        @Override
        public int getPlayersUsing() {
            return this.playersUsing;
        }

        @Override
        public void setPlayersUsing(int value) {
            this.playersUsing = value;
        }

        @Override
        public int getLidTicks() {
            return this.lidTicks;
        }

        @Override
        public int getPrevLidTicks() {
            return this.prevLidTicks;
        }

        @Override
        public void setLidTicks(int value) {
            this.prevLidTicks = this.lidTicks;
            this.lidTicks = value;
        }
    }
}

