/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.network;

import java.util.function.Predicate;
import net.mcft.copy.backpacks.network.MessageBackpackUpdate;
import net.mcft.copy.backpacks.network.MessageOpenBackpack;
import net.mcft.copy.backpacks.network.MessageOpenGui;
import net.mcft.copy.backpacks.network.MessageSyncSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class BackpacksChannel
extends SimpleNetworkWrapper {
    public BackpacksChannel() {
        super("wearablebackpacks");
        this.registerMessage(MessageSyncSettings.Handler.class, MessageSyncSettings.class, 0, Side.CLIENT);
        this.registerMessage(MessageBackpackUpdate.Handler.class, MessageBackpackUpdate.class, 1, Side.CLIENT);
        this.registerMessage(MessageOpenGui.Handler.class, MessageOpenGui.class, 2, Side.CLIENT);
        this.registerMessage(MessageOpenBackpack.Handler.class, MessageOpenBackpack.class, 3, Side.SERVER);
    }

    public void sendTo(IMessage message, EntityPlayer player) {
        this.sendTo(message, (EntityPlayerMP)player);
    }

    public void sendToAll(IMessage message, EntityPlayer except) {
        this.sendToAll(message, (EntityPlayer player) -> player != except);
    }

    public void sendToAll(IMessage message, Predicate<EntityPlayer> filter) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!filter.test(player)) continue;
            this.sendTo(message, player);
        }
    }

    public void sendToAllAround(IMessage message, World world, double x, double y, double z, double distance) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, distance));
    }

    public void sendToAllAround(IMessage message, World world, double x, double y, double z, double distance, EntityPlayer except) {
        this.sendToAllAround(message, world, x, y, z, distance, (EntityPlayer player) -> player != except);
    }

    public void sendToAllAround(IMessage message, World world, double x, double y, double z, double distance, Predicate<EntityPlayer> filter) {
        for (EntityPlayer player : world.field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (!filter.test(player) || !((dx = x - player.field_70165_t) * dx + (dy = y - player.field_70163_u) * dy + (dz = z - player.field_70161_v) * dz < distance * distance)) continue;
            this.sendTo(message, player);
        }
    }

    public void sendToAllTracking(IMessage message, Entity entity, boolean sendToEntity) {
        ((WorldServer)entity.field_70170_p).func_73039_n().func_151247_a(entity, this.getPacketFrom(message));
        if (sendToEntity && entity instanceof EntityPlayer) {
            this.sendTo(message, (EntityPlayer)entity);
        }
    }
}

