/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.combat;

import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.units.IForgeUnit;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomArmorModel {
    protected final ModelBase baseModel;
    protected final ModelBiped bipedModel;
    protected final EntityEquipmentSlot armorSlot;
    private final String texture;

    protected CustomArmorModel(IForgeUnit unit, ModelBase baseModel, final EntityEquipmentSlot armorSlot) {
        this.baseModel = baseModel;
        this.texture = ForgeLocating.armorTexture(unit.getId().getModId(), unit.getId().getRegName()).toString();
        this.armorSlot = armorSlot;
        this.bipedModel = new ModelBiped(){

            public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
                GlStateManager.func_179094_E();
                if (this.field_78091_s) {
                    GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
                    if (armorSlot == EntityEquipmentSlot.HEAD) {
                        this.field_78116_c.func_78785_a(scale);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
                    if (armorSlot == EntityEquipmentSlot.CHEST) {
                        this.field_78115_e.func_78785_a(scale);
                    }
                } else {
                    if (entityIn.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                    }
                    if (armorSlot == EntityEquipmentSlot.HEAD) {
                        this.field_78116_c.func_78785_a(scale);
                    }
                    if (armorSlot == EntityEquipmentSlot.CHEST) {
                        this.field_78115_e.func_78785_a(scale / 2.0f);
                    }
                }
                GlStateManager.func_179121_F();
            }
        };
        ModelRenderer renderedModel = new ModelRenderer((ModelBase)this.bipedModel);
        switch (armorSlot) {
            case HEAD: {
                this.bipedModel.field_78116_c = renderedModel;
                break;
            }
            case CHEST: {
                this.bipedModel.field_78115_e = renderedModel;
                break;
            }
        }
        if (renderedModel != null) {
            for (ModelRenderer box : baseModel.field_78092_r) {
                renderedModel.func_78792_a(box);
                box.func_78787_b(baseModel.field_78090_t, baseModel.field_78089_u);
            }
        }
    }

    public static CustomArmorModel of(IForgeUnit unit, ModelBase model, EntityEquipmentSlot slot) {
        return new CustomArmorModel(unit, model, slot);
    }

    public ModelBiped getModelFor(EntityLivingBase living) {
        this.bipedModel.field_78091_s = living.func_70631_g_();
        this.bipedModel.field_78117_n = living.func_70093_af();
        return this.bipedModel;
    }

    public String getTexture() {
        return this.texture;
    }
}

