/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonArray;
import com.endertech.common.CommonPath;
import com.endertech.common.CommonString;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.items.ForgeStack;
import com.endertech.minecraft.forge.units.IWithMeta;
import com.endertech.minecraft.forge.units.ItemState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class UnitId
implements IWithMeta<UnitId> {
    public static final UnitId EMPTY = UnitId.from("", "");
    public static final String FORMAT_FULL = "<modId:unitName:meta>";
    public static final String DESCRIPTION = "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nTo define multiple block states, you can use block properties instead of meta. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use just ore dictionary name as full id.\n";
    public static final String DELIMITER = ":";
    public static final String MOD_ID_MINECRAFT = "minecraft";
    public static final String REG_NAME_WORDS_DELIMITER = "_";
    public static final String UNLOCALIZED_NAME_DELIMITER = ".";
    public static final String INCODE_DELIMITER = "$";
    public static final int META_DEFAULT = 0;
    public static final int META_ALL_INT = Short.MAX_VALUE;
    public static final String META_ALL_CHAR = "*";
    public static final Pattern PATTERN = Pattern.compile("^([A-Za-z0-9_\\-$]*+)?(?::)?([A-Za-z_][A-Za-z0-9_\\-/.]*)(?::)?([0-9]{1,5}|\\*|\\[.*\\])?");
    private final String modId;
    private final String regName;
    private final String dictName;
    private final String metadata;
    protected final Cache cache = new Cache();

    public UnitId(String modId, String regName, String metadata) {
        this.modId = modId;
        this.regName = regName;
        this.dictName = UnitId.regToDictName(regName);
        this.metadata = metadata;
    }

    public static String joinWords(String delimiter, String ... words) {
        ArrayList<String> wordsList = new ArrayList<String>();
        for (String word : words) {
            if ((word = word.trim()).isEmpty()) continue;
            wordsList.add(word);
        }
        return String.join((CharSequence)delimiter, wordsList);
    }

    public static String[] capitalizeWords(String ... words) {
        String[] capitalizedWords = new String[words.length];
        for (int i = 0; i < capitalizedWords.length; ++i) {
            capitalizedWords[i] = CommonString.capitalizeFirstChar(words[i]);
        }
        return capitalizedWords;
    }

    public static String buildRegName(String ... nameWords) {
        return UnitId.joinWords(REG_NAME_WORDS_DELIMITER, nameWords).toLowerCase(Locale.ROOT);
    }

    public static String buildDictName(String ... nameWords) {
        nameWords = UnitId.capitalizeWords(nameWords);
        String dictName = String.join((CharSequence)"", nameWords);
        dictName = CommonString.decapitalizeFirstChar(dictName);
        return dictName;
    }

    public static String[] splitRegName(String regName, boolean capitalizeWords, boolean invertOrder) {
        String[] nameWords = regName.split(REG_NAME_WORDS_DELIMITER);
        if (capitalizeWords) {
            nameWords = UnitId.capitalizeWords(nameWords);
        }
        if (invertOrder) {
            CommonArray.reverse(nameWords);
        }
        return nameWords;
    }

    public static String[] splitDictName(String dictName) {
        ArrayList<String> wordsList = new ArrayList<String>();
        int wordStartsAt = 0;
        for (int i = 0; i < dictName.length(); ++i) {
            char ch = dictName.charAt(i);
            if (Character.isUpperCase(ch) && i != 0) {
                String word = dictName.substring(wordStartsAt, i);
                wordsList.add(word);
                wordStartsAt = i;
            }
            if (i != dictName.length() - 1) continue;
            String lastWord = dictName.substring(wordStartsAt);
            wordsList.add(lastWord);
        }
        return wordsList.toArray(new String[0]);
    }

    public static String regToDictName(String regName) {
        String[] nameWords = UnitId.splitRegName(regName, true, true);
        String dictName = UnitId.buildDictName(nameWords);
        return dictName;
    }

    public static String dictToRegName(String dictName) {
        String[] nameWords = UnitId.splitDictName(dictName);
        return UnitId.buildRegName(nameWords);
    }

    public static boolean isNullOrEmpty(UnitId unitId) {
        return unitId == null || unitId.isEmpty();
    }

    public boolean isEmpty() {
        return CommonString.isNullOrEmpty(this.getModId()) || CommonString.isNullOrEmpty(this.getRegName());
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public static UnitId from(String id) {
        if ((id = id.trim()).isEmpty() || id.equals(DELIMITER)) {
            return EMPTY;
        }
        Matcher matcher = PATTERN.matcher(id);
        if (matcher.matches()) {
            String metadata;
            String unitName;
            String modId = Groups.MOD_ID.getFrom(matcher);
            if (modId == null) {
                modId = MOD_ID_MINECRAFT;
            }
            if ((unitName = Groups.UNIT_NAME.getFrom(matcher)) == null) {
                unitName = "!NULL!";
            }
            if ((metadata = Groups.METADATA.getFrom(matcher)) == null) {
                metadata = "";
            }
            return new UnitId(modId, unitName, metadata);
        }
        ForgeMain.instance.getLogger().error("Unable to parse '{}'. Invalid id format", (Object)id);
        return EMPTY;
    }

    public static UnitId from(Enum<?> e, boolean withMetaAllByDefault) {
        String stringId = e instanceof IForgeEnum ? ((IForgeEnum)((Object)e)).func_176610_l() : e.name();
        stringId = stringId.replace(INCODE_DELIMITER, DELIMITER);
        UnitId unitId = UnitId.from(stringId);
        if (withMetaAllByDefault && !unitId.hasMetaData()) {
            return (UnitId)unitId.withMetaAll();
        }
        return unitId;
    }

    public static UnitId from(Path path) {
        String stringId = CommonPath.getFileNameOnly(path).replace(INCODE_DELIMITER, DELIMITER);
        return UnitId.from(stringId);
    }

    public static UnitId from(String modId, String ... nameWords) {
        return UnitId.from(modId, UnitId.buildRegName(nameWords));
    }

    public static UnitId from(String modId, String unitName) {
        return new UnitId(modId, unitName, "");
    }

    public static UnitId from(String modId, String unitName, int meta) {
        switch (meta) {
            case 0: {
                return new UnitId(modId, unitName, "");
            }
            case 32767: {
                return new UnitId(modId, unitName, META_ALL_CHAR);
            }
        }
        return new UnitId(modId, unitName, String.valueOf(meta));
    }

    public static UnitId from(ResourceLocation location, int meta) {
        return UnitId.from(location.func_110624_b(), location.func_110623_a(), meta);
    }

    public static UnitId from(Item item, int meta) {
        ResourceLocation location = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        return location != null ? UnitId.from(location, meta) : EMPTY;
    }

    public static UnitId from(Item item) {
        return UnitId.from(item, 0);
    }

    public static UnitId from(Block block, int meta) {
        ResourceLocation location = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        return location != null ? UnitId.from(location, meta) : EMPTY;
    }

    public static UnitId from(Block block) {
        return UnitId.from(block, 0);
    }

    public static UnitId from(IBlockState state) {
        return UnitId.from(state.func_177230_c(), BlockState.getMeta(state));
    }

    public static UnitId from(BlockState state) {
        return state.exists() ? UnitId.from(state.getBlock(), state.getMeta()) : EMPTY;
    }

    public static UnitId from(ItemState state) {
        return state.exists() ? UnitId.from(state.getItem(), state.getMeta()) : EMPTY;
    }

    public static boolean metasAreMatched(int meta1, int meta2) {
        return meta1 == meta2 || meta1 == Short.MAX_VALUE || meta2 == Short.MAX_VALUE;
    }

    public String getMetaData() {
        return this.metadata;
    }

    public boolean metaMatches(int meta) {
        return UnitId.metasAreMatched(this.getMeta(), meta);
    }

    @Nullable
    protected Block getBlockOrNull() {
        ResourceLocation key = this.toResLoc();
        if (Block.field_149771_c.func_148741_d((Object)key)) {
            return (Block)Block.field_149771_c.func_82594_a((Object)key);
        }
        return null;
    }

    public BlockState getBlockState() {
        if (this.cache.blockState != null) {
            return this.cache.blockState;
        }
        Block block = this.getBlockOrNull();
        int meta = this.getMeta();
        if (block == null) {
            ForgeStack stack = this.getFirstFoundOre();
            if (stack.exists()) {
                block = ForgeBlock.getBlockOrNull(stack.getItem());
            }
            if (block != null) {
                meta = stack.getMeta();
            }
        }
        if (block != null) {
            if (this.hasProperties()) {
                List<BlockState> states = this.getMatchedStates(block, this.cache.props);
                if (!states.isEmpty()) {
                    this.cache.blockState = states.get(0);
                }
            } else {
                this.cache.blockState = BlockState.from(block, meta);
            }
        }
        return this.cache.blockState != null ? this.cache.blockState : BlockState.EMPTY;
    }

    @Nullable
    public IBlockState getIBlockState() {
        if (this.cache.iblockState != null) {
            return this.cache.iblockState;
        }
        BlockState state = this.getBlockState();
        if (state.exists()) {
            int meta = state.getMeta();
            this.cache.iblockState = meta == 0 || meta == Short.MAX_VALUE ? state.getBlock().func_176223_P() : state.getBlock().func_176203_a(meta);
        }
        return this.cache.iblockState;
    }

    protected List<BlockState> getMatchedStates(Block block, List<KeyValuePair> props) {
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        HashMap properties = new HashMap();
        BlockStateContainer container = block.func_176194_O();
        for (KeyValuePair prop : props) {
            Iterator value;
            IProperty property = container.func_185920_a(prop.key);
            if (property == null || (value = property.func_185929_b(prop.value).orNull()) == null) continue;
            properties.put(property, value);
        }
        for (IBlockState state : container.func_177619_a()) {
            BlockState matchedState;
            boolean match = true;
            for (Map.Entry prop : properties.entrySet()) {
                Comparable value = state.func_177229_b((IProperty)prop.getKey());
                if (value.equals(prop.getValue())) continue;
                match = false;
                break;
            }
            if (!match || list.contains(matchedState = BlockState.from(state))) continue;
            list.add(matchedState);
        }
        return list;
    }

    @Nullable
    protected Item getItemOrNull() {
        ResourceLocation key = this.toResLoc();
        if (Item.field_150901_e.func_148741_d((Object)key)) {
            return (Item)Item.field_150901_e.func_82594_a((Object)key);
        }
        return null;
    }

    public ItemState getItemState() {
        ForgeStack stack;
        if (this.cache.itemState != null) {
            return this.cache.itemState;
        }
        Item item = this.getItemOrNull();
        int meta = this.getMeta();
        if (item == null && (stack = this.getFirstFoundOre()).exists()) {
            item = stack.getItem();
            meta = stack.getMeta();
        }
        if (item != null) {
            this.cache.itemState = ItemState.from(item, meta);
            return this.cache.itemState;
        }
        return ItemState.EMPTY;
    }

    public List<BlockState> getAllBlockStates() {
        if (this.cache.allBlockStates.isEmpty()) {
            Block block = this.getBlockOrNull();
            if (block != null) {
                if (this.hasProperties()) {
                    List<BlockState> states = this.getMatchedStates(block, this.cache.props);
                    this.cache.allBlockStates.addAll(states);
                } else {
                    BlockState state = BlockState.from(block, this.getMeta());
                    this.cache.allBlockStates.add(state);
                }
            }
            List<ItemStack> allOres = this.getAllOres();
            for (ItemStack stack : allOres) {
                block = ForgeBlock.getBlockOrNull(stack.func_77973_b());
                if (block == null) continue;
                if (this.hasProperties()) {
                    List<BlockState> states = this.getMatchedStates(block, this.cache.props);
                    for (BlockState state : states) {
                        if (this.cache.allBlockStates.contains(state)) continue;
                        this.cache.allBlockStates.add(state);
                    }
                    continue;
                }
                BlockState state = BlockState.from(block, stack.func_77960_j());
                if (this.cache.allBlockStates.contains(state)) continue;
                this.cache.allBlockStates.add(state);
            }
        }
        return Collections.unmodifiableList(this.cache.allBlockStates);
    }

    protected List<ItemStack> getAllOres() {
        if (this.cache.allOres.isEmpty() && this.isOreDictName()) {
            this.cache.allOres = OreDictionary.getOres((String)this.getDictName(), (boolean)false);
        }
        return Collections.unmodifiableList(this.cache.allOres);
    }

    protected ForgeStack getFirstFoundOre() {
        List<ItemStack> allOres = this.getAllOres();
        if (allOres.isEmpty()) {
            return ForgeStack.EMPTY;
        }
        return ForgeStack.from(allOres.get(0));
    }

    public List<ItemState> getAllItemStates() {
        if (this.cache.allItemStates.isEmpty()) {
            ItemState itemState = this.getItemState();
            if (itemState.exists()) {
                this.cache.allItemStates.add(itemState);
            }
            List<ItemStack> oreList = this.getAllOres();
            for (ItemStack stack : oreList) {
                itemState = ItemState.from(stack.func_77973_b(), stack.func_77960_j());
                if (this.cache.allItemStates.contains(itemState)) continue;
                this.cache.allItemStates.add(itemState);
            }
        }
        return Collections.unmodifiableList(this.cache.allItemStates);
    }

    @Override
    public UnitId withMeta(int meta) {
        return UnitId.from(this.getModId(), this.getRegName(), meta);
    }

    public UnitId withMetaData(String metadata) {
        return new UnitId(this.getModId(), this.getRegName(), metadata);
    }

    public UnitId withName(String newName) {
        return new UnitId(this.getModId(), newName, this.getMetaData());
    }

    public UnitId withName(String ... nameWords) {
        return new UnitId(this.getModId(), UnitId.buildRegName(nameWords), this.getMetaData());
    }

    public UnitId withNamePrefix(String prefix) {
        return this.withName(prefix, this.getRegName());
    }

    public UnitId withNameSuffix(String suffix) {
        return this.withName(this.getRegName(), suffix);
    }

    public String toString() {
        if (this.cache.string != null) {
            return this.cache.string;
        }
        StringJoiner joiner = new StringJoiner(DELIMITER);
        boolean defaultModId = this.getModId().equals(MOD_ID_MINECRAFT);
        if (!defaultModId) {
            joiner.add(this.getModId());
        }
        joiner.add(this.getRegName());
        if (this.hasMetaData()) {
            joiner.add(this.getMetaData());
        }
        this.cache.string = joiner.toString();
        if (this.cache.string.equals(DELIMITER)) {
            this.cache.string = "";
        }
        return this.cache.string;
    }

    public ResourceLocation toResLoc() {
        if (this.cache.location == null) {
            this.cache.location = new ResourceLocation(this.getModId(), this.getRegName());
        }
        return this.cache.location;
    }

    public ModelResourceLocation toModelResLoc_Inventory() {
        return this.toModelResLoc("inventory");
    }

    public ModelResourceLocation toModelResLoc_Normal() {
        return this.toModelResLoc("");
    }

    public ModelResourceLocation toModelResLoc(String variant) {
        return new ModelResourceLocation(this.toResLoc(), variant);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitId) {
            UnitId another = (UnitId)obj;
            return this.getModId().equals(another.getModId()) && this.getRegName().equals(another.getRegName()) && this.getMetaData().equals(another.getMetaData());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getModId(), this.getRegName(), this.getMetaData());
    }

    protected boolean isOreDictName() {
        return this.getRegName().equals(this.getDictName()) && this.getModId().equals(MOD_ID_MINECRAFT) && (!this.hasMetaData() || this.hasProperties());
    }

    public String getRegName() {
        return this.regName;
    }

    public String getDictName() {
        return this.dictName;
    }

    public String getModId() {
        return this.modId;
    }

    public int getMeta() {
        if (this.cache.meta != null) {
            return this.cache.meta;
        }
        this.cache.meta = this.getMetaData().equals(META_ALL_CHAR) ? Integer.valueOf(Short.MAX_VALUE) : (CommonString.allCharsAreDigits(this.metadata) ? Integer.valueOf(this.metadata) : Integer.valueOf(0));
        return this.cache.meta;
    }

    public boolean hasMetaData() {
        return !this.getMetaData().isEmpty();
    }

    public boolean hasProperties() {
        if (this.cache.props == null) {
            this.cache.props = new ArrayList<KeyValuePair>();
            String data = this.getMetaData();
            if (data.startsWith("[") && data.endsWith("]")) {
                data = data.substring(1, data.length() - 1);
                for (String elem : data.split(",")) {
                    KeyValuePair pair = KeyValuePair.from(elem);
                    if (pair.key.isEmpty() || pair.value.isEmpty() || this.cache.props.contains(pair)) continue;
                    this.cache.props.add(pair);
                }
            }
        }
        return !this.cache.props.isEmpty();
    }

    public boolean matches(BlockState state) {
        for (BlockState blockstate : this.getAllBlockStates()) {
            if (!blockstate.matches(state)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        return this.matches(ItemState.from(stack));
    }

    public boolean matches(ItemState state) {
        for (ItemState itemstate : this.getAllItemStates()) {
            if (!itemstate.matches(state)) continue;
            return true;
        }
        return false;
    }

    protected class Cache {
        public BlockState blockState;
        public IBlockState iblockState;
        public ItemState itemState;
        public List<BlockState> allBlockStates = new ArrayList<BlockState>();
        public List<ItemState> allItemStates = new ArrayList<ItemState>();
        public List<ItemStack> allOres = new ArrayList<ItemStack>();
        public List<KeyValuePair> props;
        public ResourceLocation location;
        public String string;
        public Integer meta;

        protected Cache() {
        }
    }

    protected static enum Groups {
        FULL_ID,
        MOD_ID,
        UNIT_NAME,
        METADATA;


        @Nullable
        public String getFrom(Matcher matcher) {
            return matcher.group(this.ordinal());
        }
    }
}

