/*
 * Decompiled with CFR 0.152.
 */
package ljfa.tntutils;

import java.io.File;
import java.util.IdentityHashMap;
import java.util.Map;
import ljfa.tntutils.TNTUtils;
import ljfa.tntutils.exception.InvalidConfigValueException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static Configuration conf;
    public static final String CAT_GENERAL = "general";
    public static final String CAT_BLOCKDMG = "block_damage";
    public static final String CAT_ENTDMG = "entity_damage";
    public static boolean explosionCommand;
    public static float sizeMultiplier;
    public static float dropChanceModifier;
    public static boolean disableExplosions;
    public static boolean preventChainExpl;
    public static boolean disableTNT;
    public static boolean disableTNTMinecart;
    public static boolean disableBlockDamage;
    public static boolean disableCreeperBlockDamage;
    public static Map<Block, Integer> blackWhiteList;
    public static boolean listIsWhitelist;
    public static boolean blacklistActive;
    public static boolean spareTileEntities;
    public static boolean disableEntityDamage;
    public static boolean disablePlayerDamage;
    public static boolean disableItemDamage;
    public static boolean disableNPCDamage;

    public static void loadConfig(File file) {
        if (conf == null) {
            conf = new Configuration(file);
        }
        conf.load();
        Config.loadValues();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeHandler());
    }

    public static void loadValues() {
        explosionCommand = conf.get(CAT_GENERAL, "addExplosionCommand", true, "Adds the \"/explosion\" command").setRequiresMcRestart(true).getBoolean();
        sizeMultiplier = (float)conf.get(CAT_GENERAL, "sizeMultiplier", 1.0, "Multiplies the size of all explosions by this", 0.0, 50.0).getDouble();
        dropChanceModifier = (float)conf.get(CAT_GENERAL, "dropChanceIncrease", 0.0, "Modifies the chance that explosions will drop destroyed blocks as items\n-1 = never drop anything, 0 = Vanilla behavior, 1 = always drop items.\nIncreasing will only affect explosions of size <= 10 since a large number of dropped items can cause lag.", -1.0, 1.0).getDouble();
        disableExplosions = conf.get(CAT_GENERAL, "disableExplosions", false, "Entirely disables all effects from explosions").getBoolean();
        preventChainExpl = conf.get(CAT_GENERAL, "preventChainExplosions", false, "Prevents explosions from triggering TNT and thus disables chain explosions").getBoolean();
        disableTNT = conf.get(CAT_GENERAL, "disableTNT", false, "Disables TNT explosions").setRequiresMcRestart(true).getBoolean();
        disableTNTMinecart = conf.get(CAT_GENERAL, "disableTNTMinecart", false, "Disables the placement of TNT minecarts").setRequiresMcRestart(true).getBoolean();
        listIsWhitelist = conf.get(CAT_BLOCKDMG, "destructionListIsWhitelist", false, "If false, the list above is a blacklist. If true, it is a whitelist").getBoolean();
        disableBlockDamage = conf.get(CAT_BLOCKDMG, "disableBlockDamage", false, "Disables all block damage from explosions").getBoolean();
        disableCreeperBlockDamage = conf.get(CAT_BLOCKDMG, "disableCreeperBlockDamage", false, "\"Environmentally Friendly Creepers\": Makes creepers not destroy blocks").getBoolean();
        spareTileEntities = conf.get(CAT_BLOCKDMG, "disableTileEntityDamage", false, "Makes explosions not destroy blocks with tile entities").getBoolean();
        disableEntityDamage = conf.get(CAT_ENTDMG, "disableEntityDamage", false, "Disables explosion damage to all entities (also includes minecarts, paintings etc.)").getBoolean();
        disablePlayerDamage = conf.get(CAT_ENTDMG, "disablePlayerDamage", false, "Disables explosion damage to players").getBoolean();
        disableItemDamage = conf.get(CAT_ENTDMG, "disableItemDamage", false, "Disables explosion damage to items laying on the ground").getBoolean();
        disableNPCDamage = conf.get(CAT_ENTDMG, "disableNPCDamage", false, "Disables explosion damage to animals and mobs").getBoolean();
    }

    public static void createBlacklistSet() {
        String[] blacklistArray = conf.get(CAT_BLOCKDMG, "destructionBlackOrWhitelist", new String[0], "A list of blocks (optionally with metadata) that will either never or only be destroyed by explosions\nWhether this list is a blacklist or whitelist gets determined by the \"destructionListIsWhitelist\" option below\nSyntax: modid:block or modid:block/meta").getStringList();
        blackWhiteList = new IdentityHashMap<Block, Integer>();
        for (String str : blacklistArray) {
            int metamask;
            String blockname;
            int ind = str.indexOf(47);
            if (ind != -1) {
                int meta;
                String metaStr = str.substring(ind + 1);
                try {
                    meta = Integer.parseInt(metaStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigValueException("destructionBlackOrWhitelist: Invalid number format: " + metaStr, ex);
                }
                if (meta < 0 || meta >= 16) {
                    throw new InvalidConfigValueException("destructionBlackOrWhitelist: Metadata out of range: " + metaStr);
                }
                blockname = str.substring(0, ind);
                metamask = 1 << meta;
            } else {
                blockname = str;
                metamask = 65535;
            }
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockname));
            if (block == Blocks.field_150350_a || block == null) {
                throw new InvalidConfigValueException("destructionBlackOrWhitelist: Invalid block name: " + blockname);
            }
            if (!blackWhiteList.containsKey(block)) {
                blackWhiteList.put(block, metamask);
            } else {
                blackWhiteList.put(block, metamask | blackWhiteList.get(block));
            }
            TNTUtils.logger.debug("Added block to blacklist: %s, mask 0x%X", (Object)blockname, (Object)metamask);
        }
        boolean bl = blacklistActive = blackWhiteList.size() != 0;
        if (listIsWhitelist && !blacklistActive) {
            disableBlockDamage = true;
        }
    }

    public static void modifyResistances() {
        String[] entries;
        for (String str : entries = conf.get(CAT_BLOCKDMG, "blockResistances", new String[0], "Change the explosion resistance of individual blocks.\nSyntax: modid:block=value").setRequiresMcRestart(true).getStringList()) {
            int ind = str.indexOf(61);
            if (ind == -1) {
                throw new InvalidConfigValueException("blockResistances: Syntax error: " + str);
            }
            String blockName = str.substring(0, ind);
            String valueStr = str.substring(ind + 1);
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
            if (block == Blocks.field_150350_a || block == null) {
                throw new InvalidConfigValueException("blockResistances: Invalid block name: " + blockName);
            }
            try {
                float resist = Float.parseFloat(valueStr);
                block.func_149752_b(resist);
                TNTUtils.logger.debug("Changed resistance of %s to %g", (Object)blockName, (Object)Float.valueOf(resist));
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigValueException("blockResistances: Invalid number format: " + valueStr, ex);
            }
        }
    }

    public static void save() {
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    public static class ChangeHandler {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("tnt_utilities")) {
                try {
                    Config.loadValues();
                    Config.createBlacklistSet();
                    Config.modifyResistances();
                }
                finally {
                    Config.save();
                }
            }
        }
    }
}

