/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.client.settings.KeyModifier;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, ok<Collection<bcu>>> map = new EnumMap(KeyModifier.class);

    public bcu lookupActive(int keyCode) {
        bcu binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    private bcu getBinding(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get((Object)keyModifier).a(keyCode);
        if (bindings != null) {
            for (bcu binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<bcu> lookupAll(int keyCode) {
        ArrayList<bcu> matchingBindings = new ArrayList<bcu>();
        for (ok<Collection<bcu>> bindingsMap : map.values()) {
            Collection bindings = (Collection)bindingsMap.a(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, bcu keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        ok<Collection<bcu>> bindingsMap = map.get((Object)keyModifier);
        ArrayList<bcu> bindingsForKey = (ArrayList<bcu>)bindingsMap.a(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<bcu>();
            bindingsMap.a(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(bcu keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        int keyCode = keyBinding.j();
        ok<Collection<bcu>> bindingsMap = map.get((Object)keyModifier);
        Collection bindingsForKey = (Collection)bindingsMap.a(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.d(keyCode);
            }
        }
    }

    public void clearMap() {
        for (ok<Collection<bcu>> bindings : map.values()) {
            bindings.c();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, (ok<Collection<bcu>>)new ok());
        }
    }
}

