/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final qr hand;
    private final adz stack;
    private final cm pos;
    private final ct face;

    private PlayerInteractEvent(zs player, qr hand, adz stack, cm pos, ct face) {
        super((zs)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (qr)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.stack = stack;
        this.pos = (cm)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    public qr getHand() {
        return this.hand;
    }

    @Nullable
    public adz getItemStack() {
        return this.stack;
    }

    public cm getPos() {
        return this.pos;
    }

    @Nullable
    public ct getFace() {
        return this.face;
    }

    public aid getWorld() {
        return this.getEntityPlayer().e();
    }

    public Side getSide() {
        return this.getWorld().E ? Side.CLIENT : Side.SERVER;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(zs player, adz stack) {
            super(player, qr.a, stack, new cm((rw)player), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bcb hitVec;

        public LeftClickBlock(zs player, cm pos, ct face, bcb hitVec) {
            super(player, qr.a, player.b(qr.a), pos, face);
            this.hitVec = hitVec;
        }

        public bcb getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(zs player, qr hand) {
            super(player, hand, null, new cm((rw)player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(zs player, qr hand, adz stack) {
            super(player, hand, stack, new cm((rw)player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bcb hitVec;

        public RightClickBlock(zs player, qr hand, adz stack, cm pos, ct face, bcb hitVec) {
            super(player, hand, stack, pos, face);
            this.hitVec = hitVec;
        }

        public bcb getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final rw target;

        public EntityInteract(zs player, qr hand, adz stack, rw target) {
            super(player, hand, stack, new cm(target), null);
            this.target = target;
        }

        public rw getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final bcb localPos;
        private final rw target;

        public EntityInteractSpecific(zs player, qr hand, adz stack, rw target, bcb localPos) {
            super(player, hand, stack, new cm(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public bcb getLocalPos() {
            return this.localPos;
        }

        public rw getTarget() {
            return this.target;
        }
    }
}

