/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTank
implements IFluidTank,
IFluidHandler {
    @Nullable
    protected FluidStack fluid;
    protected int capacity;
    protected aqk tile;
    protected boolean canFill = true;
    protected boolean canDrain = true;
    protected IFluidTankProperties[] tankProperties;

    public FluidTank(int capacity) {
        this(null, capacity);
    }

    public FluidTank(@Nullable FluidStack fluidStack, int capacity) {
        this.fluid = fluidStack;
        this.capacity = capacity;
    }

    public FluidTank(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public FluidTank readFromNBT(dr nbt) {
        if (!nbt.e("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT(nbt);
            this.setFluid(fluid);
        } else {
            this.setFluid(null);
        }
        return this;
    }

    public dr writeToNBT(dr nbt) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.a("Empty", "");
        }
        return nbt;
    }

    @Override
    @Nullable
    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(@Nullable FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTileEntity(aqk tile) {
        this.tile = tile;
    }

    @Override
    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this);
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        if (this.tankProperties == null) {
            this.tankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this)};
        }
        return this.tankProperties;
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent(new FluidEvent.FluidFillingEvent(this.fluid, this.tile.D(), this.tile.v(), this, this.fluid.amount));
            }
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        this.onContentsChanged();
        if (this.tile != null) {
            FluidEvent.fireEvent(new FluidEvent.FluidFillingEvent(this.fluid, this.tile.D(), this.tile.v(), this, filled));
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.canDrainFluidType(this.getFluid())) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrainFluidType(this.fluid)) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drainInternal(resource.amount, doDrain);
    }

    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
            }
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent(new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.D(), this.tile.v(), this, drained));
            }
        }
        return stack;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public void setCanFill(boolean canFill) {
        this.canFill = canFill;
    }

    public void setCanDrain(boolean canDrain) {
        this.canDrain = canDrain;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.canFill();
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.canDrain();
    }

    protected void onContentsChanged() {
    }
}

