/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import org.apache.logging.log4j.Level;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, aid world, asp chunkGenerator, asq chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.O();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : sortedGeneratorList) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        Collections.sort(list, new Comparator<IWorldGenerator>(){

            @Override
            public int compare(IWorldGenerator o1, IWorldGenerator o2) {
                return Ints.compare((int)((Integer)worldGeneratorIndex.get(o1)), (int)((Integer)worldGeneratorIndex.get(o2)));
            }
        });
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    public static <K extends IForgeRegistryEntry<?>> K register(K object) {
        return GameData.register_impl(object);
    }

    public static <K extends IForgeRegistryEntry<?>> K register(K object, kn name) {
        return GameData.register_impl(object, name);
    }

    @Deprecated
    public static akf registerWithItem(akf block) {
        GameRegistry.register(block);
        GameRegistry.register(new acl(block).setRegistryName(block.getRegistryName()));
        return block;
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistry<K> findRegistry(Class<K> registryType) {
        return PersistentRegistryManager.findRegistryByType(registryType);
    }

    public static void addSubstitutionAlias(String nameToSubstitute, Type type, Object object) throws ExistingSubstitutionException {
        GameData.getMain().registerSubstitutionAlias(nameToSubstitute, type, object);
    }

    public static void addRecipe(adz output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static agd addShapedRecipe(adz output, Object ... params) {
        return age.a().a(output, params);
    }

    public static void addShapelessRecipe(adz output, Object ... params) {
        age.a().b(output, params);
    }

    public static void addRecipe(agd recipe) {
        age.a().b().add(recipe);
    }

    public static void addSmelting(akf input, adz output, float xp) {
        afz.a().a(input, output, xp);
    }

    public static void addSmelting(adx input, adz output, float xp) {
        afz.a().a(input, output, xp);
    }

    public static void addSmelting(adz input, adz output, float xp) {
        afz.a().a(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends aqk> tileEntityClass, String id) {
        aqk.a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends aqk> tileEntityClass, String id, String ... alternatives) {
        aqk.a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(aqk.class, null, "field_145855_i", "nameToClassMap");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(adz itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static adz makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        adx item = GameData.getItemRegistry().getObject(new kn(itemName));
        if (item == null) {
            FMLLog.getLogger().log(Level.TRACE, "Unable to find item with name {}", new Object[]{itemName});
            return null;
        }
        adz is = new adz(item, stackSize, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            dr nbttag = null;
            try {
                nbttag = eh.a((String)nbtString);
            }
            catch (eg e2) {
                FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", new Object[]{nbtString, e2});
                throw Throwables.propagate((Throwable)e2);
            }
            if (!(nbttag instanceof dr)) {
                FMLLog.getLogger().log(Level.WARN, "Unexpected NBT string - multiple values {}", new Object[]{nbtString});
                throw new RuntimeException("Invalid NBT JSON");
            }
            is.d(nbttag);
        }
        return is;
    }

    @Deprecated
    public static void registerItem(adx item) {
        GameRegistry.register(item);
    }

    @Deprecated
    public static void registerItem(adx item, String name) {
        if (item.getRegistryName() == null && Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Attempted to register a item with no name: " + item);
        }
        if (item.getRegistryName() != null && !item.getRegistryName().toString().equals(name)) {
            throw new IllegalArgumentException("Attempted to register a item with conflicting names. Old: " + item.getRegistryName() + " New: " + name);
        }
        GameRegistry.register(item.getRegistryName() == null ? (adx)item.setRegistryName(name) : item);
    }

    @Deprecated
    public static akf registerBlock(akf block) {
        GameRegistry.register(block);
        GameRegistry.register(new acl(block).setRegistryName(block.getRegistryName()));
        return block;
    }

    @Deprecated
    public static akf registerBlock(akf block, String name) {
        if (block.getRegistryName() == null && Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Attempted to register a Block with no name: " + block);
        }
        if (block.getRegistryName() != null && !block.getRegistryName().toString().equals(name)) {
            throw new IllegalArgumentException("Attempted to register a Block with conflicting names. Old: " + block.getRegistryName() + " New: " + name);
        }
        return GameRegistry.registerBlock(block.getRegistryName() != null ? block : (akf)block.setRegistryName(name));
    }

    @Deprecated
    public static akf registerBlock(akf block, Class<? extends acl> itemclass) {
        return GameRegistry.registerBlock(block, itemclass, block.getRegistryName());
    }

    @Deprecated
    public static akf registerBlock(akf block, Class<? extends acl> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, new Object[0]);
    }

    @Deprecated
    public static akf registerBlock(akf block, Class<? extends acl> itemclass, Object ... itemCtorArgs) {
        return GameRegistry.registerBlock(block, itemclass, block.getRegistryName().toString(), itemCtorArgs);
    }

    @Deprecated
    public static akf registerBlock(akf block, Class<? extends acl> itemclass, String name, Object ... itemCtorArgs) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Attempted to register a block with no name: " + block);
        }
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            if (block.getRegistryName() != null && !block.getRegistryName().toString().equals(name)) {
                throw new IllegalArgumentException("Attempted to register a Block with conflicting names. Old: " + block.getRegistryName() + " New: " + name);
            }
            acl i = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
                ctorArgClasses[0] = akf.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
                }
                Constructor<? extends acl> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameRegistry.register(block.getRegistryName() == null ? (akf)block.setRegistryName(name) : block);
            if (i != null) {
                GameRegistry.register(i.setRegistryName(name));
            }
            return block;
        }
        catch (Exception e2) {
            FMLLog.log(Level.ERROR, e2, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    @Deprecated
    public static akf findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    @Deprecated
    public static adx findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ItemStackHolder {
        public String value();

        public int meta() default 0;

        public String nbt() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }

    public static enum Type {
        BLOCK,
        ITEM;

    }
}

