/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public final class CapabilityDispatcher
implements INBTSerializable<du>,
ICapabilityProvider {
    private ICapabilityProvider[] caps;
    private INBTSerializable<ei>[] writers;
    private String[] names;

    public CapabilityDispatcher(Map<kq, ICapabilityProvider> list) {
        this(list, null);
    }

    public CapabilityDispatcher(Map<kq, ICapabilityProvider> list, ICapabilityProvider parent) {
        ArrayList lstCaps = Lists.newArrayList();
        ArrayList lstWriters = Lists.newArrayList();
        ArrayList lstNames = Lists.newArrayList();
        if (parent != null) {
            lstCaps.add(parent);
            if (parent instanceof INBTSerializable) {
                lstWriters.add((INBTSerializable)((Object)parent));
                lstNames.add("Parent");
            }
        }
        for (Map.Entry<kq, ICapabilityProvider> entry : list.entrySet()) {
            ICapabilityProvider prov = entry.getValue();
            lstCaps.add(prov);
            if (!(prov instanceof INBTSerializable)) continue;
            lstWriters.add((INBTSerializable)((Object)prov));
            lstNames.add(entry.getKey().toString());
        }
        this.caps = lstCaps.toArray(new ICapabilityProvider[lstCaps.size()]);
        this.writers = lstWriters.toArray(new INBTSerializable[lstWriters.size()]);
        this.names = lstNames.toArray(new String[lstNames.size()]);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable cv facing) {
        for (ICapabilityProvider cap : this.caps) {
            if (!cap.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable cv facing) {
        for (ICapabilityProvider cap : this.caps) {
            T ret = cap.getCapability(capability, facing);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public du serializeNBT() {
        du nbt = new du();
        for (int x = 0; x < this.writers.length; ++x) {
            nbt.a(this.names[x], this.writers[x].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(du nbt) {
        for (int x = 0; x < this.writers.length; ++x) {
            if (!nbt.e(this.names[x])) continue;
            this.writers[x].deserializeNBT(nbt.c(this.names[x]));
        }
    }

    public boolean areCompatible(CapabilityDispatcher other) {
        if (other == null) {
            return this.writers.length == 0;
        }
        if (this.writers.length == 0) {
            return other.writers.length == 0;
        }
        return this.serializeNBT().equals((Object)other.serializeNBT());
    }
}

