/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public final class TRSRTransformation
implements IModelState,
ITransformation {
    private final javax.vecmath.Matrix4f matrix;
    private boolean full;
    private javax.vecmath.Vector3f translation;
    private Quat4f leftRot;
    private javax.vecmath.Vector3f scale;
    private Quat4f rightRot;
    private static final TRSRTransformation identity;
    private static final float eps = 1.0E-6f;
    private static final float g;
    private static final float cs;
    private static final float ss;
    private static final float sq2;
    private static final EnumMap<cv, TRSRTransformation> vanillaUvTransformLocalToGlobal;
    private static final EnumMap<cv, TRSRTransformation> vanillaUvTransformGlobalToLocal;

    public TRSRTransformation(javax.vecmath.Matrix4f matrix) {
        this.matrix = matrix == null ? TRSRTransformation.identity.matrix : matrix;
    }

    public TRSRTransformation(javax.vecmath.Vector3f translation, Quat4f leftRot, javax.vecmath.Vector3f scale, Quat4f rightRot) {
        this.matrix = TRSRTransformation.mul(translation, leftRot, scale, rightRot);
        this.translation = translation != null ? translation : new javax.vecmath.Vector3f();
        this.leftRot = leftRot != null ? leftRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = scale != null ? scale : new javax.vecmath.Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRot = rightRot != null ? rightRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.full = true;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(brn transform) {
        this(TRSRTransformation.toVecmath(transform.c), TRSRTransformation.quatFromXYZDegrees(TRSRTransformation.toVecmath(transform.b)), TRSRTransformation.toVecmath(transform.d), null);
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(cbf rotation) {
        this(rotation.getMatrix());
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(cv facing) {
        this(TRSRTransformation.getMatrix(facing));
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Matrix4f getMatrix(cv facing) {
        switch (facing) {
            case a: {
                return cbf.e.getMatrix();
            }
            case b: {
                return cbf.m.getMatrix();
            }
            case c: {
                return TRSRTransformation.identity.matrix;
            }
            case d: {
                return cbf.c.getMatrix();
            }
            case e: {
                return cbf.d.getMatrix();
            }
            case f: {
                return cbf.b.getMatrix();
            }
        }
        return new javax.vecmath.Matrix4f();
    }

    public static TRSRTransformation identity() {
        return identity;
    }

    public TRSRTransformation compose(TRSRTransformation b2) {
        javax.vecmath.Matrix4f m = this.getMatrix();
        m.mul(b2.getMatrix());
        return new TRSRTransformation(m);
    }

    public TRSRTransformation inverse() {
        if (this == identity) {
            return this;
        }
        javax.vecmath.Matrix4f m = this.getMatrix();
        m.invert();
        return new TRSRTransformation(m);
    }

    private void genCheck() {
        if (!this.full) {
            Pair<Matrix3f, javax.vecmath.Vector3f> pair = TRSRTransformation.toAffine(this.matrix);
            Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> triple = TRSRTransformation.svdDecompose((Matrix3f)pair.getLeft());
            this.translation = (javax.vecmath.Vector3f)pair.getRight();
            this.leftRot = (Quat4f)triple.getLeft();
            this.scale = (javax.vecmath.Vector3f)triple.getMiddle();
            this.rightRot = (Quat4f)triple.getRight();
            this.full = true;
        }
    }

    public static Quat4f quatFromYXZ(float y, float x, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static Quat4f quatFromXYZDegrees(javax.vecmath.Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ((float)Math.toRadians(xyz.x), (float)Math.toRadians(xyz.y), (float)Math.toRadians(xyz.z));
    }

    public static Quat4f quatFromXYZ(javax.vecmath.Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ(xyz.x, xyz.y, xyz.z);
    }

    public static Quat4f quatFromXYZ(float x, float y, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f));
        ret.mul(t);
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static javax.vecmath.Vector3f toYXZDegrees(Quat4f q) {
        javax.vecmath.Vector3f yxz = TRSRTransformation.toYXZ(q);
        return new javax.vecmath.Vector3f((float)Math.toDegrees(yxz.x), (float)Math.toDegrees(yxz.y), (float)Math.toDegrees(yxz.z));
    }

    public static javax.vecmath.Vector3f toYXZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l2 = w2 + x2 + y2 + z2;
        float sx2 = 2.0f * q.w * q.x - 2.0f * q.y * q.z;
        float x = (float)Math.asin(sx2 / l2);
        if (Math.abs(sx2) > 0.999f * l2) {
            return new javax.vecmath.Vector3f(x, 2.0f * (float)Math.atan2(q.y, q.w), 0.0f);
        }
        return new javax.vecmath.Vector3f(x, (float)Math.atan2(2.0f * q.x * q.z + 2.0f * q.y * q.w, w2 - x2 - y2 + z2), (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 - x2 + y2 - z2));
    }

    public static javax.vecmath.Vector3f toXYZDegrees(Quat4f q) {
        javax.vecmath.Vector3f xyz = TRSRTransformation.toXYZ(q);
        return new javax.vecmath.Vector3f((float)Math.toDegrees(xyz.x), (float)Math.toDegrees(xyz.y), (float)Math.toDegrees(xyz.z));
    }

    public static javax.vecmath.Vector3f toXYZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l2 = w2 + x2 + y2 + z2;
        float sy = 2.0f * q.w * q.x - 2.0f * q.y * q.z;
        float y = (float)Math.asin(sy / l2);
        if (Math.abs(sy) > 0.999f * l2) {
            return new javax.vecmath.Vector3f(2.0f * (float)Math.atan2(q.x, q.w), y, 0.0f);
        }
        return new javax.vecmath.Vector3f((float)Math.atan2(2.0f * q.y * q.z + 2.0f * q.x * q.w, w2 - x2 - y2 + z2), y, (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 + x2 - y2 - z2));
    }

    public static javax.vecmath.Matrix4f mul(javax.vecmath.Vector3f translation, Quat4f leftRot, javax.vecmath.Vector3f scale, Quat4f rightRot) {
        javax.vecmath.Matrix4f res = new javax.vecmath.Matrix4f();
        javax.vecmath.Matrix4f t = new javax.vecmath.Matrix4f();
        res.setIdentity();
        if (leftRot != null) {
            t.set(leftRot);
            res.mul(t);
        }
        if (scale != null) {
            t.setIdentity();
            t.m00 = scale.x;
            t.m11 = scale.y;
            t.m22 = scale.z;
            res.mul(t);
        }
        if (rightRot != null) {
            t.set(rightRot);
            res.mul(t);
        }
        if (translation != null) {
            res.setTranslation(translation);
        }
        return res;
    }

    public static Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> svdDecompose(Matrix3f m) {
        Quat4f u = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f v = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f qt = new Quat4f();
        Matrix3f b2 = new Matrix3f(m);
        Matrix3f t = new Matrix3f();
        t.transpose(m);
        b2.mul(t, b2);
        for (int i = 0; i < 5; ++i) {
            v.mul(TRSRTransformation.stepJacobi(b2));
        }
        v.normalize();
        t.set(v);
        b2.set(m);
        b2.mul(t);
        float ul = 1.0f;
        Pair<Float, Float> p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m10);
        qt.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
        t.m10 = -2.0f * qt.z * qt.w;
        t.m01 = -t.m10;
        t.m22 = qt.w * qt.w + qt.z * qt.z;
        ul *= t.m22;
        b2.mul(t, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m20);
        qt.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
        t.m20 = 2.0f * qt.y * qt.w;
        t.m02 = -t.m20;
        t.m11 = qt.w * qt.w + qt.y * qt.y;
        ul *= t.m11;
        b2.mul(t, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m11, b2.m21);
        qt.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
        t.m21 = -2.0f * qt.x * qt.w;
        t.m12 = -t.m21;
        t.m00 = qt.w * qt.w + qt.x * qt.x;
        ul *= t.m00;
        b2.mul(t, b2);
        ul = 1.0f / ul;
        u.scale((float)Math.sqrt(ul));
        javax.vecmath.Vector3f s = new javax.vecmath.Vector3f(b2.m00 * ul, b2.m11 * ul, b2.m22 * ul);
        return Triple.of((Object)u, (Object)s, (Object)v);
    }

    private static float rsqrt(float f) {
        float f2 = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    private static Pair<Float, Float> approxGivensQuat(float a11, float a12, float a22) {
        float sh2 = a12;
        float ch = 2.0f * (a11 - a22);
        boolean b2 = g * sh2 * sh2 < ch * ch;
        float w = TRSRTransformation.rsqrt(sh2 * sh2 + ch * ch);
        ch = b2 ? w * ch : cs;
        sh2 = b2 ? w * sh2 : ss;
        return Pair.of((Object)Float.valueOf(sh2), (Object)Float.valueOf(ch));
    }

    private static final void swapNeg(Matrix3f m, int i, int j2) {
        float[] t = new float[3];
        m.getColumn(j2, t);
        for (int k2 = 0; k2 < 3; ++k2) {
            m.setElement(k2, j2, -m.getElement(k2, i));
        }
        m.setColumn(i, t);
    }

    private static void sortSingularValues(Matrix3f b2, Quat4f v) {
        float f;
        float p0 = b2.m00 * b2.m00 + b2.m10 * b2.m10 + b2.m20 * b2.m20;
        float p1 = b2.m01 * b2.m01 + b2.m11 * b2.m11 + b2.m21 * b2.m21;
        float p2 = b2.m02 * b2.m02 + b2.m12 * b2.m12 + b2.m22 * b2.m22;
        Quat4f t = new Quat4f();
        if (p0 < p1) {
            TRSRTransformation.swapNeg(b2, 0, 1);
            t.set(0.0f, 0.0f, sq2, sq2);
            v.mul(t);
            f = p0;
            p0 = p1;
            p1 = f;
        }
        if (p0 < p2) {
            TRSRTransformation.swapNeg(b2, 0, 2);
            t.set(0.0f, sq2, 0.0f, sq2);
            v.mul(t);
            f = p0;
            p0 = p2;
            p2 = f;
        }
        if (p1 < p2) {
            TRSRTransformation.swapNeg(b2, 1, 2);
            t.set(sq2, 0.0f, 0.0f, sq2);
            v.mul(t);
        }
    }

    private static Pair<Float, Float> qrGivensQuat(float a1, float a2) {
        float p2 = (float)Math.sqrt(a1 * a1 + a2 * a2);
        float sh2 = p2 > 1.0E-6f ? a2 : 0.0f;
        float ch = Math.abs(a1) + Math.max(p2, 1.0E-6f);
        if (a1 < 0.0f) {
            float f = sh2;
            sh2 = ch;
            ch = f;
        }
        float w = TRSRTransformation.rsqrt(ch * ch + sh2 * sh2);
        return Pair.of((Object)Float.valueOf(sh2 *= w), (Object)Float.valueOf(ch *= w));
    }

    private static Quat4f stepJacobi(Matrix3f m) {
        Pair<Float, Float> p2;
        Matrix3f t = new Matrix3f();
        Quat4f qt = new Quat4f();
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        if (m.m01 * m.m01 + m.m10 * m.m10 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m01 + m.m10), m.m11);
            qt.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
            t.m10 = 2.0f * qt.z * qt.w;
            t.m01 = -t.m10;
            t.m22 = qt.w * qt.w + qt.z * qt.z;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        if (m.m02 * m.m02 + m.m20 * m.m20 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m02 + m.m20), m.m22);
            qt.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
            t.m20 = -2.0f * qt.y * qt.w;
            t.m02 = -t.m20;
            t.m11 = qt.w * qt.w + qt.y * qt.y;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        if (m.m12 * m.m12 + m.m21 * m.m21 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m.m11, 0.5f * (m.m12 + m.m21), m.m22);
            qt.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
            t.m21 = 2.0f * qt.x * qt.w;
            t.m12 = -t.m21;
            t.m00 = qt.w * qt.w + qt.x * qt.x;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        return ret;
    }

    public static Pair<Matrix3f, javax.vecmath.Vector3f> toAffine(javax.vecmath.Matrix4f m) {
        m.mul(1.0f / m.m33);
        javax.vecmath.Vector3f trans = new javax.vecmath.Vector3f(m.m03, m.m13, m.m23);
        Matrix3f linear = new Matrix3f(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
        return Pair.of((Object)linear, (Object)trans);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public brn toItemTransform() {
        return new brn(TRSRTransformation.toLwjgl(TRSRTransformation.toXYZDegrees(this.getLeftRot())), TRSRTransformation.toLwjgl(this.getTranslation()), TRSRTransformation.toLwjgl(this.getScale()));
    }

    @Override
    public javax.vecmath.Matrix4f getMatrix() {
        return (javax.vecmath.Matrix4f)this.matrix.clone();
    }

    public javax.vecmath.Vector3f getTranslation() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.translation.clone();
    }

    public Quat4f getLeftRot() {
        this.genCheck();
        return (Quat4f)this.leftRot.clone();
    }

    public javax.vecmath.Vector3f getScale() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.scale.clone();
    }

    public Quat4f getRightRot() {
        this.genCheck();
        return (Quat4f)this.rightRot.clone();
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)this);
    }

    @Override
    public cv rotate(cv facing) {
        return TRSRTransformation.rotate(this.matrix, facing);
    }

    public static cv rotate(javax.vecmath.Matrix4f matrix, cv facing) {
        dl dir = facing.n();
        Vector4f vec = new Vector4f((float)dir.p(), (float)dir.q(), (float)dir.r(), 0.0f);
        matrix.transform((Tuple4f)vec);
        return cv.a((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static boolean isInteger(javax.vecmath.Matrix4f matrix) {
        javax.vecmath.Matrix4f m = new javax.vecmath.Matrix4f();
        m.setIdentity();
        m.m32 = 1.0f;
        m.m31 = 1.0f;
        m.m30 = 1.0f;
        m.m33 = 0.0f;
        m.mul(matrix, m);
        for (int i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                float v = m.getElement(i, j2) / m.getElement(3, j2);
                if (!((double)Math.abs(v - (float)Math.round(v)) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rotate(cv facing, int vertexIndex) {
        return vertexIndex;
    }

    public String toString() {
        this.genCheck();
        return Objects.toStringHelper(this.getClass()).add("matrix", (Object)this.matrix).add("translation", (Object)this.translation).add("leftRot", (Object)this.leftRot).add("scale", (Object)this.scale).add("rightRot", (Object)this.rightRot).toString();
    }

    public static TRSRTransformation blockCenterToCorner(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public static TRSRTransformation blockCornerToCenter(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRSRTransformation other = (TRSRTransformation)obj;
        return !(this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix));
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Vector3f toVecmath(Vector3f vec) {
        return new javax.vecmath.Vector3f(vec.x, vec.y, vec.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector4f toVecmath(org.lwjgl.util.vector.Vector4f vec) {
        return new Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Matrix4f toVecmath(Matrix4f m) {
        return new javax.vecmath.Matrix4f(m.m00, m.m10, m.m20, m.m30, m.m01, m.m11, m.m21, m.m31, m.m02, m.m12, m.m22, m.m32, m.m03, m.m13, m.m23, m.m33);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector3f toLwjgl(javax.vecmath.Vector3f vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static org.lwjgl.util.vector.Vector4f toLwjgl(Vector4f vec) {
        return new org.lwjgl.util.vector.Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    @SideOnly(value=Side.CLIENT)
    public static Matrix4f toLwjgl(javax.vecmath.Matrix4f m) {
        Matrix4f r2 = new Matrix4f();
        r2.m00 = m.m00;
        r2.m01 = m.m10;
        r2.m02 = m.m20;
        r2.m03 = m.m30;
        r2.m10 = m.m01;
        r2.m11 = m.m11;
        r2.m12 = m.m21;
        r2.m13 = m.m31;
        r2.m20 = m.m02;
        r2.m21 = m.m12;
        r2.m22 = m.m22;
        r2.m23 = m.m32;
        r2.m30 = m.m03;
        r2.m31 = m.m13;
        r2.m32 = m.m23;
        r2.m33 = m.m33;
        return r2;
    }

    public static javax.vecmath.Vector3f lerp(Tuple3f from, Tuple3f to, float progress) {
        javax.vecmath.Vector3f res = new javax.vecmath.Vector3f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Vector4f lerp(Tuple4f from, Tuple4f to, float progress) {
        Vector4f res = new Vector4f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Quat4f slerp(Quat4f from, Quat4f to, float progress) {
        Quat4f res = new Quat4f();
        res.interpolate(from, to, progress);
        return res;
    }

    public TRSRTransformation slerp(TRSRTransformation that, float progress) {
        return new TRSRTransformation(TRSRTransformation.lerp((Tuple3f)this.getTranslation(), (Tuple3f)that.getTranslation(), progress), TRSRTransformation.slerp(this.getLeftRot(), that.getLeftRot(), progress), TRSRTransformation.lerp((Tuple3f)this.getScale(), (Tuple3f)that.getScale(), progress), TRSRTransformation.slerp(this.getRightRot(), that.getRightRot(), progress));
    }

    public static TRSRTransformation getVanillaUvTransformLocalToGlobal(cv side) {
        return vanillaUvTransformLocalToGlobal.get(side);
    }

    public static TRSRTransformation getVanillaUvTransformGlobalToLocal(cv side) {
        return vanillaUvTransformGlobalToLocal.get(side);
    }

    public TRSRTransformation getUVLockTransform(cv originalSide) {
        cv newSide = this.rotate(originalSide);
        try {
            return TRSRTransformation.blockCenterToCorner(vanillaUvTransformGlobalToLocal.get(originalSide).compose(TRSRTransformation.blockCornerToCenter(this.inverse())).compose(vanillaUvTransformLocalToGlobal.get(newSide)));
        }
        catch (SingularMatrixException e) {
            return new TRSRTransformation(null, null, new javax.vecmath.Vector3f(0.0f, 0.0f, 0.0f), null);
        }
    }

    static {
        javax.vecmath.Matrix4f m = new javax.vecmath.Matrix4f();
        m.setIdentity();
        identity = new TRSRTransformation(m);
        identity.getLeftRot();
        g = 3.0f + 2.0f * (float)Math.sqrt(2.0);
        cs = (float)Math.cos(0.39269908169872414);
        ss = (float)Math.sin(0.39269908169872414);
        sq2 = 1.0f / (float)Math.sqrt(2.0);
        vanillaUvTransformLocalToGlobal = Maps.newEnumMap(cv.class);
        vanillaUvTransformGlobalToLocal = Maps.newEnumMap(cv.class);
        vanillaUvTransformLocalToGlobal.put(cv.d, identity);
        Quat4f tmp = new Quat4f();
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.f, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.e, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(180.0)));
        vanillaUvTransformLocalToGlobal.put(cv.c, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.b, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.a, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        for (cv side : cv.values()) {
            vanillaUvTransformGlobalToLocal.put(side, vanillaUvTransformLocalToGlobal.get(side).inverse());
        }
    }
}

