/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final ajq world;
    private final co pos;
    private final atj state;

    public BlockEvent(ajq world, co pos, atj state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public ajq getWorld() {
        return this.world;
    }

    public co getPos() {
        return this.pos;
    }

    public atj getState() {
        return this.state;
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(ajq world, co pos, atj state) {
            super(world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final atj originalState;

            public Post(ajq world, co pos, atj original, atj state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public atj getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(ajq world, co pos, atj state) {
                super(world, pos, state);
            }
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(ajq world, co pos, atj state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<cv> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(ajq world, co pos, atj state, EnumSet<cv> notifiedSides, boolean forceRedstoneUpdate) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<cv> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        @Deprecated
        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, atj placedAgainst, aax player) {
            this(blockSnapshots, placedAgainst, player, null);
        }

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, atj placedAgainst, aax player, @Nullable rh hand) {
            super(blockSnapshots.get(0), placedAgainst, player, hand);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.getItemInHand(), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final aax player;
        private final afi itemInHand;
        private final BlockSnapshot blockSnapshot;
        private final atj placedBlock;
        private final atj placedAgainst;
        private final rh hand;

        @Deprecated
        public PlaceEvent(BlockSnapshot blockSnapshot, atj placedAgainst, aax player) {
            this(blockSnapshot, placedAgainst, player, null);
        }

        public PlaceEvent(BlockSnapshot blockSnapshot, atj placedAgainst, aax player, @Nullable rh hand) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.itemInHand = player.b(hand != null ? hand : rh.a);
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            this.hand = hand;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ][Hand: %s]\n", this.getPlacedBlock(), placedAgainst, this.getItemInHand(), player, hand);
            }
        }

        public aax getPlayer() {
            return this.player;
        }

        @Nullable
        public afi getItemInHand() {
            return this.itemInHand;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public atj getPlacedBlock() {
            return this.placedBlock;
        }

        public atj getPlacedAgainst() {
            return this.placedAgainst;
        }

        @Nullable
        public rh getHand() {
            return this.hand;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final aax player;
        private int exp;

        public BreakEvent(ajq world, co pos, atj state, aax player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.v(), player, (aju)world, pos) || state.v().canSilkHarvest(world, pos, world.o(pos), player) && aij.a((aih)ail.s, (afi)player.cg()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = aij.a((aih)ail.u, (afi)player.cg());
                this.exp = state.v().getExpDrop(state, (aju)world, pos, bonusLevel);
            }
        }

        public aax getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<afi> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final aax harvester;

        public HarvestDropsEvent(ajq world, co pos, atj state, int fortuneLevel, float dropChance, List<afi> drops, aax harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<afi> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public aax getHarvester() {
            return this.harvester;
        }
    }
}

