/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    public static final int BUCKET_VOLUME = 1000;
    protected final String fluidName;
    protected String unlocalizedName;
    protected final kq still;
    protected final kq flowing;
    private nm fillSound;
    private nm emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected afw rarity = afw.a;
    protected als block = null;

    public Fluid(String fluidName, kq still, kq flowing) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(als block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to the Block " + this.block + ". You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", new Object[0]);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(afw rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(nm fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(nm emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final als getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.t().a() == azq.h;
    }

    public void vaporize(@Nullable aax player, ajq worldIn, co pos, FluidStack fluidStack) {
        worldIn.a(player, pos, nn.bH, no.e, 0.5f, 2.6f + (worldIn.r.nextFloat() - worldIn.r.nextFloat()) * 0.8f);
        for (int l2 = 0; l2 < 8; ++l2) {
            worldIn.a(de.m, (double)pos.p() + Math.random(), (double)pos.q() + Math.random(), (double)pos.r() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : dp.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public afw getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return -1;
    }

    public kq getStill() {
        return this.still;
    }

    public kq getFlowing() {
        return this.flowing;
    }

    public nm getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().t().a() == azq.i ? nn.Q : nn.P;
        }
        return this.fillSound;
    }

    public nm getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().t().a() == azq.i ? nn.O : nn.N;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public afw getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public kq getStill(FluidStack stack) {
        return this.getStill();
    }

    public kq getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public nm getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public nm getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(ajq world, co pos) {
        return this.getLuminosity();
    }

    public int getDensity(ajq world, co pos) {
        return this.getDensity();
    }

    public int getTemperature(ajq world, co pos) {
        return this.getTemperature();
    }

    public int getViscosity(ajq world, co pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(ajq world, co pos) {
        return this.isGaseous();
    }

    public afw getRarity(ajq world, co pos) {
        return this.getRarity();
    }

    public int getColor(ajq world, co pos) {
        return this.getColor();
    }

    public kq getStill(ajq world, co pos) {
        return this.getStill();
    }

    public kq getFlowing(ajq world, co pos) {
        return this.getFlowing();
    }

    public nm getFillSound(ajq world, co pos) {
        return this.getFillSound();
    }

    public nm getEmptySound(ajq world, co pos) {
        return this.getEmptySound();
    }
}

