/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.security.cert.Certificate;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public class MinecraftDummyContainer
extends DummyModContainer {
    private VersionRange staticRange;

    public MinecraftDummyContainer(String actualMCVersion) {
        super(new ModMetadata());
        this.getMetadata().modId = "minecraft";
        this.getMetadata().name = "Minecraft";
        this.getMetadata().version = actualMCVersion;
        this.staticRange = VersionParser.parseRange("[" + actualMCVersion + "]");
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public File getSource() {
        return new File("minecraft.jar");
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        return true;
    }

    public VersionRange getStaticVersionRange() {
        return this.staticRange;
    }

    @Override
    public Certificate getSigningCertificate() {
        if (FMLLaunchHandler.side() != Side.CLIENT) {
            return null;
        }
        try {
            Class<?> cbr = Class.forName("net.minecraft.client.ClientBrandRetriever", false, this.getClass().getClassLoader());
            Certificate[] certificates = cbr.getProtectionDomain().getCodeSource().getCertificates();
            return certificates != null ? certificates[0] : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

