/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<dd<afi>> idToStack = Lists.newArrayList();
    private static List<dd<afi>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final dd<afi> EMPTY_LIST = dd.a();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new afi(alt.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new afi(alt.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new afi(alt.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new afi((als)alt.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", alt.ad);
            OreDictionary.registerOre("stairWood", alt.bU);
            OreDictionary.registerOre("stairWood", alt.bV);
            OreDictionary.registerOre("stairWood", alt.bW);
            OreDictionary.registerOre("stairWood", alt.cC);
            OreDictionary.registerOre("stairWood", alt.cD);
            OreDictionary.registerOre("stickWood", afk.B);
            OreDictionary.registerOre("treeSapling", new afi(alt.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new afi((als)alt.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new afi((als)alt.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", alt.bn);
            OreDictionary.registerOre("oreGold", alt.o);
            OreDictionary.registerOre("oreIron", alt.p);
            OreDictionary.registerOre("oreLapis", alt.x);
            OreDictionary.registerOre("oreDiamond", alt.ag);
            OreDictionary.registerOre("oreRedstone", alt.aC);
            OreDictionary.registerOre("oreEmerald", alt.bP);
            OreDictionary.registerOre("oreQuartz", alt.co);
            OreDictionary.registerOre("oreCoal", alt.q);
            OreDictionary.registerOre("ingotIron", afk.m);
            OreDictionary.registerOre("ingotGold", afk.n);
            OreDictionary.registerOre("ingotBrick", afk.aP);
            OreDictionary.registerOre("ingotBrickNether", afk.cq);
            OreDictionary.registerOre("nuggetGold", afk.bF);
            OreDictionary.registerOre("gemDiamond", afk.l);
            OreDictionary.registerOre("gemEmerald", afk.bZ);
            OreDictionary.registerOre("gemQuartz", afk.cr);
            OreDictionary.registerOre("gemPrismarine", afk.cN);
            OreDictionary.registerOre("dustPrismarine", afk.cO);
            OreDictionary.registerOre("dustRedstone", afk.aF);
            OreDictionary.registerOre("dustGlowstone", afk.bb);
            OreDictionary.registerOre("gemLapis", new afi(afk.be, 1, 4));
            OreDictionary.registerOre("blockGold", alt.R);
            OreDictionary.registerOre("blockIron", alt.S);
            OreDictionary.registerOre("blockLapis", alt.y);
            OreDictionary.registerOre("blockDiamond", alt.ah);
            OreDictionary.registerOre("blockRedstone", alt.cn);
            OreDictionary.registerOre("blockEmerald", alt.bT);
            OreDictionary.registerOre("blockQuartz", alt.cq);
            OreDictionary.registerOre("blockCoal", alt.cA);
            OreDictionary.registerOre("cropWheat", afk.R);
            OreDictionary.registerOre("cropPotato", afk.cd);
            OreDictionary.registerOre("cropCarrot", afk.cc);
            OreDictionary.registerOre("cropNetherWart", afk.bG);
            OreDictionary.registerOre("sugarcane", afk.aR);
            OreDictionary.registerOre("blockCactus", (als)alt.aK);
            OreDictionary.registerOre("dye", new afi(afk.be, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new afi(afk.aS));
            OreDictionary.registerOre("slimeball", afk.aU);
            OreDictionary.registerOre("enderpearl", afk.bC);
            OreDictionary.registerOre("bone", afk.bf);
            OreDictionary.registerOre("gunpowder", afk.K);
            OreDictionary.registerOre("string", afk.I);
            OreDictionary.registerOre("netherStar", afk.ck);
            OreDictionary.registerOre("leather", afk.aN);
            OreDictionary.registerOre("feather", afk.J);
            OreDictionary.registerOre("egg", afk.aX);
            OreDictionary.registerOre("record", afk.cB);
            OreDictionary.registerOre("record", afk.cC);
            OreDictionary.registerOre("record", afk.cD);
            OreDictionary.registerOre("record", afk.cE);
            OreDictionary.registerOre("record", afk.cF);
            OreDictionary.registerOre("record", afk.cG);
            OreDictionary.registerOre("record", afk.cH);
            OreDictionary.registerOre("record", afk.cI);
            OreDictionary.registerOre("record", afk.cJ);
            OreDictionary.registerOre("record", afk.cK);
            OreDictionary.registerOre("record", afk.cL);
            OreDictionary.registerOre("record", afk.cM);
            OreDictionary.registerOre("dirt", alt.d);
            OreDictionary.registerOre("grass", (als)alt.c);
            OreDictionary.registerOre("stone", alt.b);
            OreDictionary.registerOre("cobblestone", alt.e);
            OreDictionary.registerOre("gravel", alt.n);
            OreDictionary.registerOre("sand", new afi((als)alt.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new afi(alt.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new afi(alt.cM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", alt.aV);
            OreDictionary.registerOre("obsidian", alt.Z);
            OreDictionary.registerOre("glowstone", alt.aX);
            OreDictionary.registerOre("endstone", alt.bH);
            OreDictionary.registerOre("torch", alt.aa);
            OreDictionary.registerOre("workbench", alt.ai);
            OreDictionary.registerOre("blockSlime", alt.cE);
            OreDictionary.registerOre("blockPrismarine", new afi(alt.cI, 1, apr.a.a.a()));
            OreDictionary.registerOre("blockPrismarineBrick", new afi(alt.cI, 1, apr.a.b.a()));
            OreDictionary.registerOre("blockPrismarineDark", new afi(alt.cI, 1, apr.a.c.a()));
            OreDictionary.registerOre("stoneGranite", new afi(alt.b, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new afi(alt.b, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new afi(alt.b, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new afi(alt.b, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new afi(alt.b, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new afi(alt.b, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", alt.w);
            OreDictionary.registerOre("blockGlass", alt.w);
            OreDictionary.registerOre("blockGlass", new afi((als)alt.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", alt.bj);
            OreDictionary.registerOre("paneGlass", alt.bj);
            OreDictionary.registerOre("paneGlass", new afi((als)alt.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", (als)alt.ae);
            OreDictionary.registerOre("chest", alt.bQ);
            OreDictionary.registerOre("chest", alt.cg);
            OreDictionary.registerOre("chestWood", (als)alt.ae);
            OreDictionary.registerOre("chestEnder", alt.bQ);
            OreDictionary.registerOre("chestTrapped", alt.cg);
        }
        HashMap<afi, String> replacements = new HashMap<afi, String>();
        replacements.put(new afi(afk.B), "stickWood");
        replacements.put(new afi(alt.f), "plankWood");
        replacements.put(new afi(alt.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new afi((als)alt.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new afi(afk.n), "ingotGold");
        replacements.put(new afi(afk.m), "ingotIron");
        replacements.put(new afi(afk.l), "gemDiamond");
        replacements.put(new afi(afk.bZ), "gemEmerald");
        replacements.put(new afi(afk.cN), "gemPrismarine");
        replacements.put(new afi(afk.cO), "dustPrismarine");
        replacements.put(new afi(afk.aF), "dustRedstone");
        replacements.put(new afi(afk.bb), "dustGlowstone");
        replacements.put(new afi(afk.aR), "sugarcane");
        replacements.put(new afi((als)alt.aK), "blockCactus");
        replacements.put(new afi(afk.aS), "paper");
        replacements.put(new afi(afk.aU), "slimeball");
        replacements.put(new afi(afk.I), "string");
        replacements.put(new afi(afk.aN), "leather");
        replacements.put(new afi(afk.bC), "enderpearl");
        replacements.put(new afi(afk.K), "gunpowder");
        replacements.put(new afi(afk.ck), "netherStar");
        replacements.put(new afi(afk.J), "feather");
        replacements.put(new afi(afk.bf), "bone");
        replacements.put(new afi(afk.aX), "egg");
        replacements.put(new afi(alt.b), "stone");
        replacements.put(new afi(alt.e), "cobblestone");
        replacements.put(new afi(alt.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new afi(alt.aX), "glowstone");
        replacements.put(new afi(alt.w), "blockGlassColorless");
        replacements.put(new afi(alt.cI), "prismarine");
        replacements.put(new afi(alt.b, 1, 1), "stoneGranite");
        replacements.put(new afi(alt.b, 1, 2), "stoneGranitePolished");
        replacements.put(new afi(alt.b, 1, 3), "stoneDiorite");
        replacements.put(new afi(alt.b, 1, 4), "stoneDioritePolished");
        replacements.put(new afi(alt.b, 1, 5), "stoneAndesite");
        replacements.put(new afi(alt.b, 1, 6), "stoneAndesitePolished");
        replacements.put(new afi((als)alt.ae), "chestWood");
        replacements.put(new afi(alt.bQ), "chestEnder");
        replacements.put(new afi(alt.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            afi dye = new afi(afk.be, 1, i);
            afi block = new afi((als)alt.cG, 1, 15 - i);
            afi pane = new afi((als)alt.cH, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        afi[] replaceStacks = replacements.keySet().toArray(new afi[replacements.keySet().size()]);
        afi[] exclusions = new afi[]{new afi(alt.y), new afi(afk.bk), new afi(alt.bf), new afi((als)alt.U, 1, Short.MAX_VALUE), new afi(alt.aw), new afi(alt.bZ), new afi(alt.aO), new afi(alt.bo), new afi(alt.ad), new afi(alt.aP), new afi(alt.bp), new afi(alt.bU), new afi(alt.bV), new afi(alt.bq), new afi(alt.bV), new afi(alt.aR), new afi(alt.br), new afi(alt.bW), new afi(alt.aT), new afi(alt.bt), new afi(alt.cC), new afi(alt.aS), new afi(alt.bs), new afi(alt.cD), new afi((als)alt.bM), new afi(alt.bj), new afi(alt.di), new afi(afk.aH), new afi(afk.at), afi.a};
        List recipes = aho.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            afi output;
            ahq recipe;
            if (obj.getClass() == ahq.class) {
                recipe = (ahq)obj;
                output = recipe.b();
                if (!output.b() && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (obj.getClass() != ahr.class || !(output = (recipe = (ahr)obj).b()).b() && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new afi[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((ahn)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((ahr)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipes", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            dd back = dd.a();
            idToStack.add((dd<afi>)back);
            idToStackUn.add((dd<afi>)back);
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(@Nonnull afi stack) {
        if (stack.b()) {
            throw new IllegalArgumentException("Stack can not be invalid!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        kq registryName = stack.c().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.i() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static dd<afi> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static dd<afi> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static dd<afi> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, afi[] inputs, afi ... targets) {
        for (afi input : inputs) {
            for (afi target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, dd<afi> inputs, afi ... targets) {
        for (afi input : inputs) {
            for (afi target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(@Nonnull afi target, @Nonnull afi input, boolean strict) {
        if (input.b() && !target.b() || !input.b() && target.b()) {
            return false;
        }
        return target.c() == input.c() && (target.i() == Short.MAX_VALUE && !strict || target.i() == input.i());
    }

    public static void registerOre(String name, afg ore) {
        OreDictionary.registerOre(name, new afi(ore));
    }

    public static void registerOre(String name, als ore) {
        OreDictionary.registerOre(name, new afi(ore));
    }

    public static void registerOre(String name, @Nonnull afi ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, @Nonnull afi ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore.b()) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        kq registryName = ore.c().delegate.name();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.c().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.i() != Short.MAX_VALUE) {
            hash |= ore.i() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.l();
        idToStack.get(oreID).add((Object)ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            dd<afi> ores = idToStack.get(id);
            if (ores == null) continue;
            for (afi ore : ores) {
                ArrayList ids;
                int hash;
                kq name = ore.c().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id), ore.c().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.i() != Short.MAX_VALUE) {
                    hash |= ore.i() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final afi Ore;

        public OreRegisterEvent(String name, @Nonnull afi ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        @Nonnull
        public afi getOre() {
            return this.Ore;
        }
    }
}

