/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.transformation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.transformation.ConfigurationTransformation;
import ninja.leaping.configurate.transformation.MoveStrategy;
import ninja.leaping.configurate.transformation.TransformAction;
import org.checkerframework.checker.nullness.qual.NonNull;

class SingleConfigurationTransformation
extends ConfigurationTransformation {
    private final MoveStrategy strategy;
    private final Map<Object[], TransformAction> actions;
    private final ThreadLocal<ConfigurationTransformation.NodePath> sharedPath = ThreadLocal.withInitial(ConfigurationTransformation.NodePath::new);

    SingleConfigurationTransformation(Map<Object[], TransformAction> actions, MoveStrategy strategy) {
        this.actions = actions;
        this.strategy = strategy;
    }

    @Override
    public void apply(@NonNull ConfigurationNode node) {
        for (Map.Entry<Object[], TransformAction> ent : this.actions.entrySet()) {
            this.applySingleAction(node, ent.getKey(), 0, node, ent.getValue());
        }
    }

    private void applySingleAction(ConfigurationNode start, Object[] path, int startIdx, ConfigurationNode node, TransformAction action) {
        for (int i = startIdx; i < path.length; ++i) {
            if (path[i] == WILDCARD_OBJECT) {
                if (node.hasListChildren()) {
                    List<? extends ConfigurationNode> children = node.getChildrenList();
                    for (int di = 0; di < children.size(); ++di) {
                        path[i] = di;
                        this.applySingleAction(start, path, i + 1, children.get(di), action);
                    }
                    path[i] = WILDCARD_OBJECT;
                } else if (node.hasMapChildren()) {
                    for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
                        path[i] = ent.getKey();
                        this.applySingleAction(start, path, i + 1, ent.getValue(), action);
                    }
                    path[i] = WILDCARD_OBJECT;
                } else {
                    return;
                }
                return;
            }
            if (!(node = node.getNode(path[i])).isVirtual()) continue;
            return;
        }
        ConfigurationTransformation.NodePath nodePath = this.sharedPath.get();
        nodePath.arr = path;
        Object[] transformedPath = action.visitPath(nodePath, node);
        if (transformedPath != null && !Arrays.equals(path, transformedPath)) {
            this.strategy.move(node, start.getNode(transformedPath));
            node.setValue(null);
        }
    }
}

