/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args.parsing;

import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.text.Text;

class TokenizerState {
    private final boolean lenient;
    private final String buffer;
    private int index = -1;

    TokenizerState(String buffer, boolean lenient) {
        this.buffer = buffer;
        this.lenient = lenient;
    }

    public boolean hasMore() {
        return this.index + 1 < this.buffer.length();
    }

    public int peek() throws ArgumentParseException {
        if (!this.hasMore()) {
            throw this.createException(Text.of("Buffer overrun while parsing args"));
        }
        return this.buffer.codePointAt(this.index + 1);
    }

    public int next() throws ArgumentParseException {
        if (!this.hasMore()) {
            throw this.createException(Text.of("Buffer overrun while parsing args"));
        }
        return this.buffer.codePointAt(++this.index);
    }

    public ArgumentParseException createException(Text message) {
        return new ArgumentParseException(message, this.buffer, this.index);
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public int getIndex() {
        return this.index;
    }
}

