/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.extra.modifier.skylands;

import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.noise.Noise;
import com.flowpowered.noise.NoiseQuality;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.extra.modifier.skylands.SkylandsUtil;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;

@Deprecated
public class SkylandsGroundCoverPopulator
implements GenerationPopulator {
    private static final GroundCoverLayer[] LAYERS = new GroundCoverLayer[]{new UniformGroundCoverLayer(BlockTypes.GRASS, 1), new VariableGroundCoverLayer(BlockTypes.DIRT, 1, 4)};
    private static final double HOLE_THRESHOLD = 0.6;

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        Vector3i max = buffer.getBlockMax();
        Vector3i min = buffer.getBlockMin();
        int yMax = max.getY();
        int yMin = min.getY();
        if (yMax < 29 || yMin > 111) {
            return;
        }
        long seed = world.getProperties().getSeed();
        int intSeed = (int)(seed >> 32 ^ seed);
        int yStart = Math.min(yMax, 111);
        int yEnd = Math.max(yMin, 29);
        int xMin = min.getX();
        int zMin = min.getZ();
        int xMax = max.getX();
        int zMax = max.getZ();
        for (int zz = zMin; zz <= zMax; ++zz) {
            block1: for (int xx = xMin; xx <= xMax; ++xx) {
                int yy = yStart;
                int layerNumber = 0;
                while (yy >= yEnd && (yy = SkylandsUtil.getNextSolid(buffer, xx, yy, zz, yEnd)) >= yEnd) {
                    if (Noise.gradientCoherentNoise3D((double)xx * 0.01, 0.0, (double)zz * 0.01, intSeed ^ layerNumber, NoiseQuality.FAST) < 0.6) {
                        block3: for (GroundCoverLayer layer : LAYERS) {
                            int yBottom = yy - layer.getDepth(xx, yy, zz, layerNumber, seed);
                            BlockType cover = layer.getBlock(xx, yy, zz, layerNumber, seed);
                            while (yy > yBottom) {
                                if (yy < yEnd) continue block1;
                                if (buffer.getBlockType(xx, yy, zz).equals(BlockTypes.AIR)) break block3;
                                buffer.setBlockType(xx, yy, zz, cover);
                                --yy;
                            }
                        }
                    }
                    ++layerNumber;
                    yy = SkylandsUtil.getNextAir(buffer, xx, yy, zz, yEnd);
                }
            }
        }
    }

    private static class UniformGroundCoverLayer
    extends GroundCoverLayer {
        private final BlockType block;
        private final int depth;

        UniformGroundCoverLayer(BlockType block, int depth) {
            this.block = block;
            this.depth = depth;
        }

        @Override
        protected BlockType getBlock(int x, int y, int z, int layer, long seed) {
            return this.block;
        }

        @Override
        protected int getDepth(int x, int y, int z, int layer, long seed) {
            return this.depth;
        }
    }

    private static class VariableGroundCoverLayer
    extends GroundCoverLayer {
        private final BlockType block;
        private final int min;
        private final int max;

        VariableGroundCoverLayer(BlockType block, int minDepth, int maxDepth) {
            this.block = block;
            this.min = minDepth;
            this.max = maxDepth;
        }

        @Override
        protected BlockType getBlock(int x, int y, int z, int layer, long seed) {
            return this.block;
        }

        @Override
        protected int getDepth(int x, int y, int z, int layer, long seed) {
            return (int)(SkylandsUtil.hashToFloat(x, layer, z, seed) * (float)(this.max - this.min + 1) + (float)this.min);
        }
    }

    private static abstract class GroundCoverLayer {
        private GroundCoverLayer() {
        }

        protected abstract BlockType getBlock(int var1, int var2, int var3, int var4, long var5);

        protected abstract int getDepth(int var1, int var2, int var3, int var4, long var5);
    }
}

