/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;

public interface Schematic
extends ArchetypeVolume {
    public static final String METADATA_NAME = "Name";
    public static final String METADATA_AUTHOR = "Author";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_REQUIRED_MODS = "RequiredMods";

    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    @Deprecated
    public BlockPalette getPalette();

    default public Palette<BlockState> getBlockPalette() {
        return this.getPalette();
    }

    default public Palette<BiomeType> getBiomePalette() {
        return PaletteTypes.GLOBAL_BIOMES.create();
    }

    public DataView getMetadata();

    @Override
    public MutableBlockVolumeWorker<Schematic> getBlockWorker();

    default public Optional<MutableBiomeVolume> getBiomes() {
        return Optional.empty();
    }

    @Override
    default public ListMultimap<Vector3d, EntityArchetype> getEntitiesByPosition() {
        return ImmutableListMultimap.of();
    }

    @Override
    default public Collection<EntityArchetype> getEntityArchetypes() {
        return Collections.emptyList();
    }

    public static interface Builder
    extends ResettableBuilder<Schematic, Builder> {
        public Builder volume(ArchetypeVolume var1);

        public Builder volume(Extent var1);

        @Deprecated
        public Builder palette(BlockPalette var1);

        default public Builder blockPalette(Palette<BlockState> palette) {
            return this.palette((BlockPalette)palette);
        }

        default public Builder biomePalette(Palette<BiomeType> palette) {
            return this;
        }

        @Deprecated
        public Builder paletteType(BlockPaletteType var1);

        default public Builder blockPaletteType(PaletteType<BlockState> type) {
            return this.paletteType((BlockPaletteType)type);
        }

        default public Builder biomePaletteType(PaletteType<BiomeType> type) {
            return this;
        }

        default public Builder entity(EntityArchetype entityArchetype) {
            if (!entityArchetype.getEntityData().contains(Queries.POSITION_X, Queries.POSITION_Y, Queries.POSITION_Z)) {
                throw new IllegalArgumentException("EntityArchetype is missing position information!");
            }
            return this;
        }

        default public Builder entity(EntityArchetype entityArchetype, Vector3d position) {
            return this;
        }

        default public Builder entities(Collection<EntityArchetype> entities) {
            return this;
        }

        public Builder metadata(DataView var1);

        public Builder metaValue(String var1, Object var2);

        public Schematic build() throws IllegalArgumentException;
    }
}

