/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.advancement.SpongeTrigger;
import org.spongepowered.common.data.persistence.JsonDataFormat;

public class SpongeTriggerBuilder<C extends FilteredTriggerConfiguration>
implements Trigger.Builder<C> {
    private static final Gson GSON = new Gson();
    private static final FilteredTriggerConfiguration.Empty EMPTY_TRIGGER_CONFIGURATION = new FilteredTriggerConfiguration.Empty();
    private static final Function<JsonObject, FilteredTriggerConfiguration.Empty> EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR = jsonObject -> EMPTY_TRIGGER_CONFIGURATION;
    @Nullable
    private Class<C> configType;
    @Nullable
    private Function<JsonObject, C> constructor;
    @Nullable
    private Consumer<CriterionEvent.Trigger<C>> eventHandler;
    @Nullable
    private String id;
    @Nullable
    private String name;

    @Override
    public <T extends FilteredTriggerConfiguration & DataSerializable> Trigger.Builder<T> dataSerializableConfig(Class<T> dataConfigClass) {
        Preconditions.checkNotNull(dataConfigClass, (Object)"dataConfigClass");
        this.configType = dataConfigClass;
        this.constructor = new DataSerializableConstructor(dataConfigClass);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass) {
        return this.typeSerializableConfig(configClass, TypeSerializers.getDefaultSerializers());
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass, TypeSerializerCollection typeSerializerCollection) {
        Preconditions.checkNotNull(configClass, (Object)"configClass");
        Preconditions.checkNotNull((Object)typeSerializerCollection, (Object)"typeSerializerCollection");
        this.configType = configClass;
        this.constructor = new ConfigurateConstructor(configClass, typeSerializerCollection);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass, Gson gson) {
        Preconditions.checkNotNull(configClass, (Object)"configClass");
        this.configType = configClass;
        this.constructor = new JsonConstructor(configClass, gson);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass) {
        return this.jsonSerializableConfig(configClass, GSON);
    }

    @Override
    public Trigger.Builder<FilteredTriggerConfiguration.Empty> emptyConfig() {
        this.configType = FilteredTriggerConfiguration.Empty.class;
        this.constructor = EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR;
        return this;
    }

    @Override
    public Trigger.Builder<C> listener(Consumer<CriterionEvent.Trigger<C>> eventListener) {
        this.eventHandler = eventListener;
        return this;
    }

    @Override
    public Trigger.Builder<C> id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.id = id;
        return this;
    }

    @Override
    public Trigger.Builder<C> name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.name = name;
        return this;
    }

    @Override
    public Trigger<C> build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"The id must be set");
        Preconditions.checkState((this.configType != null ? 1 : 0) != 0, (Object)"The configType must be set");
        PluginContainer plugin = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).get();
        String name = StringUtils.isNotEmpty((CharSequence)this.name) ? this.name : this.id;
        return (Trigger)((Object)new SpongeTrigger(this.configType, this.constructor, new ResourceLocation(plugin.getId(), this.id), this.eventHandler, name));
    }

    @Override
    public Trigger.Builder<C> reset() {
        this.configType = null;
        this.constructor = null;
        this.eventHandler = null;
        this.id = null;
        this.name = null;
        return this;
    }

    private static class JsonConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final Class<C> configClass;
        private final Gson gson;

        private JsonConstructor(Class<C> configClass, Gson gson) {
            this.configClass = configClass;
            this.gson = gson;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            return (C)((FilteredTriggerConfiguration)this.gson.fromJson((JsonElement)jsonObject, this.configClass));
        }
    }

    private static class ConfigurateConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final TypeToken<C> typeToken;
        private final TypeSerializerCollection typeSerializerCollection;

        private ConfigurateConstructor(Class<C> typeToken, TypeSerializerCollection typeSerializerCollection) {
            this.typeToken = TypeToken.of(typeToken);
            this.typeSerializerCollection = typeSerializerCollection;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setSource(() -> new BufferedReader(new StringReader(GSON.toJson((JsonElement)jsonObject))))).build();
            try {
                Object node = loader.load();
                return (C)((FilteredTriggerConfiguration)this.typeSerializerCollection.get(this.typeToken).deserialize(this.typeToken, (ConfigurationNode)node));
            }
            catch (IOException | ObjectMappingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class DataSerializableConstructor<C extends FilteredTriggerConfiguration & DataSerializable>
    implements Function<JsonObject, C> {
        private final Class<C> dataConfigClass;

        private DataSerializableConstructor(Class<C> dataConfigClass) {
            this.dataConfigClass = dataConfigClass;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            DataBuilder<C> builder = Sponge.getDataManager().getBuilder(this.dataConfigClass).get();
            try {
                DataContainer dataView = JsonDataFormat.serialize(GSON, jsonObject);
                return (C)((FilteredTriggerConfiguration)builder.build(dataView).get());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

