/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.datasync.DataParameterConverter;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;

public class EntityAirConverter
extends DataParameterConverter<Integer> {
    public EntityAirConverter() {
        super(EntityAccessor.accessor$getAirParameter());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Integer currentValue, Integer value) {
        return Optional.of(DataTransactionResult.builder().replace(new ImmutableSpongeBoundedValue<Integer>(Keys.REMAINING_AIR, 300, currentValue, Integer::compareTo, 0, 300)).success(new ImmutableSpongeBoundedValue<Integer>(Keys.REMAINING_AIR, 300, value, Integer::compareTo, 0, 300)).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Integer getValueFromEvent(Integer originalValue, List<ImmutableValue<?>> immutableValues) {
        for (ImmutableValue<?> value : immutableValues) {
            if (value.getKey() != Keys.REMAINING_AIR) continue;
            return (Integer)value.get();
        }
        return originalValue;
    }
}

