/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMappedData;
import org.spongepowered.api.data.manipulator.mutable.MappedData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableMappedData<K, V, I extends ImmutableMappedData<K, V, I, M>, M extends MappedData<K, V, M, I>>
extends AbstractImmutableSingleData<Map<K, V>, I, M>
implements ImmutableMappedData<K, V, I, M> {
    private final Class<? extends M> mutableClass;
    private final ImmutableMapValue<K, V> mapValue;

    public AbstractImmutableMappedData(Class<I> immutableClass, Map<K, V> value, Key<? extends BaseValue<Map<K, V>>> usedKey, Class<? extends M> manipulatorClass) {
        super(immutableClass, ImmutableMap.copyOf(value), usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(manipulatorClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(manipulatorClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.mutableClass = manipulatorClass;
        this.mapValue = new ImmutableSpongeMapValue(this.usedKey, ImmutableMap.copyOf((Map)((Map)this.value)));
    }

    protected final ImmutableMapValue<K, V> getValueGetter() {
        return this.mapValue;
    }

    @Override
    public Map<K, V> getValue() {
        return ImmutableMap.copyOf((Map)((Map)super.getValue()));
    }

    @Override
    public M asMutable() {
        return (M)((MappedData)ReflectionUtil.createInstance(this.mutableClass, this.value));
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(((Map)super.getValue()).get(Preconditions.checkNotNull(key, (Object)"Key cannot be null!")));
    }

    @Override
    public Set<K> getMapKeys() {
        return ((Map)super.getValue()).keySet();
    }

    @Override
    public ImmutableMapValue<K, V> getMapValue() {
        return this.mapValue;
    }
}

