/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDamageableData;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDamageableData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;

public class ImmutableSpongeDamageableData
extends AbstractImmutableData<ImmutableDamageableData, DamageableData>
implements ImmutableDamageableData {
    @Nullable
    private final EntitySnapshot lastAttacker;
    @Nullable
    private final Double lastDamage;
    private final ImmutableOptionalValue<EntitySnapshot> lastAttackerValue;
    private final ImmutableOptionalValue<Double> lastDamageValue;

    public ImmutableSpongeDamageableData() {
        this((EntitySnapshot)null, null);
    }

    public ImmutableSpongeDamageableData(@Nullable EntitySnapshot lastAttacker, @Nullable Double lastDamage) {
        super(ImmutableDamageableData.class);
        this.lastAttacker = lastAttacker;
        this.lastDamage = lastDamage;
        this.lastAttackerValue = new ImmutableSpongeOptionalValue<EntitySnapshot>(Keys.LAST_ATTACKER, Optional.ofNullable(this.lastAttacker));
        this.lastDamageValue = new ImmutableSpongeOptionalValue<Double>(Keys.LAST_DAMAGE, Optional.ofNullable(this.lastDamage));
        this.registerGetters();
    }

    public ImmutableSpongeDamageableData(@Nullable Living lastAttacker, @Nullable Double lastDamage) {
        this(lastAttacker == null ? null : lastAttacker.createSnapshot(), lastDamage);
    }

    @Override
    public ImmutableOptionalValue<EntitySnapshot> lastAttacker() {
        return this.lastAttackerValue;
    }

    @Override
    public ImmutableOptionalValue<Double> lastDamage() {
        return this.lastDamageValue;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.LAST_ATTACKER, () -> Optional.ofNullable(this.lastAttacker));
        this.registerKeyValue(Keys.LAST_ATTACKER, () -> this.lastAttackerValue);
        this.registerFieldGetter(Keys.LAST_DAMAGE, () -> Optional.ofNullable(this.lastDamage));
        this.registerKeyValue(Keys.LAST_DAMAGE, () -> this.lastDamageValue);
    }

    @Override
    public DamageableData asMutable() {
        return new SpongeDamageableData(this.lastAttacker, this.lastDamage);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.LAST_ATTACKER, (Object)Optional.ofNullable(this.lastAttacker)).set(Keys.LAST_DAMAGE, (Object)Optional.ofNullable(this.lastDamage));
    }
}

