/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHealthData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHealthData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeHealthData
extends AbstractImmutableData<ImmutableHealthData, HealthData>
implements ImmutableHealthData {
    private final double health;
    private final double maxHealth;
    private final ImmutableBoundedValue<Double> healthValue;
    private final ImmutableBoundedValue<Double> maxHealthValue;

    public ImmutableSpongeHealthData(double health, double maxHealth) {
        super(ImmutableHealthData.class);
        this.health = health;
        this.maxHealth = maxHealth;
        this.healthValue = SpongeValueFactory.boundedBuilder(Keys.HEALTH).actualValue(this.health).defaultValue(this.maxHealth).minimum(0.0).maximum(this.maxHealth).build().asImmutable();
        this.maxHealthValue = SpongeValueFactory.boundedBuilder(Keys.MAX_HEALTH).actualValue(this.maxHealth).defaultValue(20.0).minimum(0.0).maximum(3.4028234663852886E38).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public ImmutableBoundedValue<Double> health() {
        return this.healthValue;
    }

    @Override
    public ImmutableBoundedValue<Double> maxHealth() {
        return this.maxHealthValue;
    }

    @Override
    public HealthData asMutable() {
        return new SpongeHealthData(this.health, this.maxHealth);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HEALTH.getQuery(), (Object)this.health).set(Keys.MAX_HEALTH.getQuery(), (Object)this.maxHealth);
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.HEALTH, this::getHealth);
        this.registerKeyValue(Keys.HEALTH, this::health);
        this.registerFieldGetter(Keys.MAX_HEALTH, this::getMaxHealth);
        this.registerKeyValue(Keys.MAX_HEALTH, this::maxHealth);
    }

    public double getHealth() {
        return this.health;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }
}

