/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.tileentity;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableEndGatewayData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.EndGatewayData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.tileentity.ImmutableSpongeEndGatewayData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class SpongeEndGatewayData
extends AbstractData<EndGatewayData, ImmutableEndGatewayData>
implements EndGatewayData {
    private Vector3i exitPortal;
    private boolean exactTeleport;
    private long age;
    private int teleportCooldown;

    public SpongeEndGatewayData() {
        this(Vector3i.ONE, false, 0L, 0);
    }

    public SpongeEndGatewayData(Vector3i exitPortal, boolean exactTeleport, long age, int teleportCooldown) {
        super(EndGatewayData.class);
        this.exitPortal = exitPortal;
        this.exactTeleport = exactTeleport;
        this.age = age;
        this.teleportCooldown = teleportCooldown;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerKeyValue(Keys.EXIT_POSITION, this::exitPosition);
        this.registerFieldGetter(Keys.EXIT_POSITION, this::getExitPortal);
        this.registerFieldSetter(Keys.EXIT_POSITION, this::setExitPortal);
        this.registerKeyValue(Keys.EXACT_TELEPORT, this::exactTeleport);
        this.registerFieldGetter(Keys.EXACT_TELEPORT, this::getExactTeleport);
        this.registerFieldSetter(Keys.EXACT_TELEPORT, this::setExactTeleport);
        this.registerKeyValue(Keys.END_GATEWAY_AGE, this::age);
        this.registerFieldGetter(Keys.END_GATEWAY_AGE, this::getAge);
        this.registerFieldSetter(Keys.END_GATEWAY_AGE, this::setAge);
        this.registerKeyValue(Keys.END_GATEWAY_TELEPORT_COOLDOWN, this::teleportCooldown);
        this.registerFieldGetter(Keys.END_GATEWAY_TELEPORT_COOLDOWN, this::getTeleportCooldown);
        this.registerFieldSetter(Keys.END_GATEWAY_TELEPORT_COOLDOWN, this::setTeleportCooldown);
    }

    @Override
    public Value<Vector3i> exitPosition() {
        return new SpongeValue<Vector3i>(Keys.EXIT_POSITION, Vector3i.ONE, this.exitPortal);
    }

    private Vector3i getExitPortal() {
        return this.exitPortal;
    }

    private void setExitPortal(Vector3i exitPortal) {
        this.exitPortal = exitPortal;
    }

    @Override
    public Value<Boolean> exactTeleport() {
        return new SpongeValue<Boolean>(Keys.EXACT_TELEPORT, false, this.exactTeleport);
    }

    private boolean getExactTeleport() {
        return this.exactTeleport;
    }

    private void setExactTeleport(boolean exactTeleport) {
        this.exactTeleport = exactTeleport;
    }

    @Override
    public Value<Long> age() {
        return new SpongeValue<Long>(Keys.END_GATEWAY_AGE, 0L, this.age);
    }

    private long getAge() {
        return this.age;
    }

    private void setAge(long age) {
        this.age = age;
    }

    @Override
    public Value<Integer> teleportCooldown() {
        return new SpongeValue<Integer>(Keys.END_GATEWAY_TELEPORT_COOLDOWN, 0, this.teleportCooldown);
    }

    private int getTeleportCooldown() {
        return this.teleportCooldown;
    }

    private void setTeleportCooldown(int teleportCooldown) {
        this.teleportCooldown = teleportCooldown;
    }

    @Override
    public EndGatewayData copy() {
        return new SpongeEndGatewayData(this.exitPortal, this.exactTeleport, this.age, this.teleportCooldown);
    }

    @Override
    public ImmutableEndGatewayData asImmutable() {
        return new ImmutableSpongeEndGatewayData(this.exitPortal, this.exactTeleport, this.age, this.teleportCooldown);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.EXIT_POSITION.getQuery(), (Object)this.exitPortal).set(Keys.EXACT_TELEPORT.getQuery(), (Object)this.exactTeleport).set(Keys.END_GATEWAY_TELEPORT_COOLDOWN.getQuery(), (Object)this.teleportCooldown);
    }
}

