/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.block;

import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePistonData;
import org.spongepowered.api.data.manipulator.mutable.block.PistonData;
import org.spongepowered.api.data.type.PistonType;
import org.spongepowered.api.data.type.PistonTypes;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.common.data.manipulator.mutable.block.SpongePistonData;
import org.spongepowered.common.data.processor.common.AbstractCatalogDataProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class PistonDataProcessor
extends AbstractCatalogDataProcessor<PistonType, Value<PistonType>, PistonData, ImmutablePistonData> {
    public PistonDataProcessor() {
        super(Keys.PISTON_TYPE, (ItemStack input) -> input.func_77973_b() == ItemTypes.PISTON);
    }

    @Override
    protected int setToMeta(PistonType value) {
        return -1;
    }

    @Override
    protected PistonType getFromMeta(int meta) {
        boolean isSticky = (meta & 8) > 0;
        return isSticky ? PistonTypes.STICKY : PistonTypes.NORMAL;
    }

    @Override
    public PistonData createManipulator() {
        return new SpongePistonData();
    }

    @Override
    protected boolean set(ItemStack itemStack, PistonType value) {
        int oldMeta = itemStack.func_77952_i();
        boolean isSticky = (oldMeta & 8) > 0;
        boolean isStickyValue = value.equals(PistonTypes.STICKY);
        if (isSticky && !isStickyValue) {
            itemStack.func_77964_b(oldMeta - 8);
        }
        if (!isSticky && isStickyValue) {
            itemStack.func_77964_b(oldMeta + 8);
        }
        return true;
    }

    @Override
    protected PistonType getDefaultValue() {
        return PistonTypes.NORMAL;
    }

    @Override
    protected Value<PistonType> constructValue(PistonType actualValue) {
        return new SpongeValue<PistonType>(this.key, this.getDefaultValue(), actualValue);
    }
}

