/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAggressiveData;
import org.spongepowered.api.data.manipulator.mutable.entity.AggressiveData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.OptBool;
import org.spongepowered.common.bridge.entity.AggressiveBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAggressiveData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class AggressiveDataProcessor
extends AbstractSingleDataSingleTargetProcessor<AggressiveBridge, Boolean, Value<Boolean>, AggressiveData, ImmutableAggressiveData> {
    public AggressiveDataProcessor() {
        super(Keys.ANGRY, AggressiveBridge.class);
    }

    @Override
    protected boolean set(AggressiveBridge entity, Boolean value) {
        entity.bridge$setAngry(value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(AggressiveBridge entity) {
        return OptBool.of(entity.bridge$isAngry());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.ANGRY, false, value);
    }

    @Override
    protected AggressiveData createManipulator() {
        return new SpongeAggressiveData();
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.ANGRY, false, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

